<?php

/**
 * @var string   $modelClass         The name of the model which is being currently shown.
 * @var array    $crumbs             Breadcrumbs that point to the current location, relative to the
 *      home.
 * @var array    $bookmarks          The list of user defined bookmarks.
 * @var string   $locale             The locale abbreviation of the currently selected language.
 * @var string   $content_for_layout The main content to show inside the layout.
 * @var string   $scripts_for_layout The list of all javascript scripts to use in the backed.
 * @var mixed    $jsConfig           The configuration that is send from the backend to javascript.
 * @var string[] $jsPolyglot         The list of all translations for the javascript.
 */

// Check if the user is logged in
if (!isset($loggedIn)) {
	$loggedIn = !empty($administrator) && is_array($administrator);
}

?>
<!DOCTYPE html>
<html>
<head>
	<?= $this->Html->charset() ?>

	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>
		<?php if (!empty($crumbs)) {
			foreach (array_reverse($crumbs) as $crumb) {
				echo is_array($crumb) ? reset($crumb) : $crumb, Configure::read('Website.separator');
			}
		}
		echo __('Vector CMS') ?>
	</title>

	<?= $this->element('layout/head') ?>

	<script src="/js/googlemaps.js"></script>

</head>

<body class="<?= $loggedIn ? 'authorized' : 'login-screen' ?>">

<?php if (!$loggedIn) { ?>
	<img class="bottom-image" src="/theme/decoration.png" />
<?php } ?>

<a class="top" name="top"></a>

<?php if (Configure::read('ajax')) { ?>
	<script type="text/javascript">
		function callback(hash) {
			if (hash !== '') {
				$.get(
					hash,
					function (response) {
						eval("response = " + response + ";");
						$('#' + response.target).html(response.content);
					}
				);
			}
		}

		$(document).ready(function () {
			$.history.init(callback);
			$("a[rel~=ajax]").attr('rel', '').click(function () {
				$.history.load($(this).attr('href').replace(/^.*#/, ''));
				return false;
			});
		});
	</script>
<?php } ?>

<?= $this->element('layout/main-menu') ?>

<div id="sb-site">
	<img class="bottom-image" src="/theme/decoration.png" />
	<div id="primary"<?= !empty($administrator) && is_array($administrator) ? ' style="padding-top:84px"' : null ?>>
		<?= $this->Session->flash() ?>

		<div id="PageLoader">
			<span><i class="fa fa-fw fa-chrome fa-spin"></i> <?= __('Please wait') ?></span>
		</div>

		<div<?= !empty($administrator) && is_array($administrator) ? ' id="content"' : null ?>>
			<?= $content_for_layout ?>
		</div>
	</div>

	<?= $this->element('layout/footer') ?>
</div>

<div class="sb-slidebar sb-left sb-style-overlay">
	<nav role="navigation">
		<ul class="nav">
			<?= $this->element('layout/menu') ?>
		</ul>
	</nav>
</div>

<div class="sb-slidebar sb-right sb-style-overlay">
	<?= $this->element('layout/profile') ?>
</div>

<script type="text/javascript">
	window.CMSConfig = <?= json_encode($jsConfig) ?>;
	window.CMSPolyglot = <?= json_encode($jsPolyglot) ?>;
</script>

<?php
echo $this->Html->script([ 'inheritance',

	# jQuery
	'jquery/jquery.history',
	'jquery/jquery.stylish-select',
	'jquery/jquery.taboverride-1.0',
	'jquery/jquery-ui.min',
	'jquery/jquery.time-picker',
	'jquery/jquery.fileupload',

	# Twitter boostrap base
	'/plugins/bootstrap/js/tether.min',
	'/plugins/bootstrap/js/bootstrap.min',

	# Plugins
	'/plugins/handlebars/handlebars.min-7b74175',
	'/plugins/codemirror/js/codemirror',
	'/plugins/treeview/jquery.treeview',
	'/plugins/treetable/js/jquery.treeTable',
	'/plugins/sliderbars/js/slidebars.min',
	'/plugins/uniform/jquery.uniform.min',
	'/plugins/coolpick/js/coolpick',
	'/plugins/showup/jquery.showup-2.1.9',
	'/plugins/nxDialog/nxDialog',
	'/plugins/nxShortcuts/nxShortcuts',
	'/plugins/nxFileTransport/nxFileTransport',
	'/plugins/nxVisibilityToggle/nxVisibilityToggle',

	# Rte
	'/plugins/innova/scripts/innovaeditor',
	'/plugins/tinymce/tinymce.min',

	# Handlebars
	'handlebars/handlebars.js',
	'handlebars/templates.js',
	'handlebars/helpers/filesize.js',
	'handlebars/helpers/polyglot.js',
	'handlebars/helpers/config.js',
	'handlebars/helpers/ifImageExtension.js'
]);

echo "\n\t" . str_replace('</script><script', "</script>\n\t<script", $scripts_for_layout);
?>

<?= $this->Html->script('layouts/default') ?>

<?= $this->fetch('requirejsScripts'); ?>

<script>

	<?php if(true || !LOCALHOST) { ?>

	// Warn user on unsaved changes in the form
	UnsavedFormWatcher.init(
		'.scaffold-form input, .scaffold-form select, .scaffold-form textarea',
		CMSPolyglot['Warning: Your changes have not been saved.']
	);
	<?php } ?>

	// Add all shortcuts defined in the controller
	<?php if(!empty($nxShortcuts)) foreach($nxShortcuts as $shortcut) { ?>
	nxShortcuts.add('<?= $shortcut['command'] ?>', function () {
		try {
			<?= $shortcut['action'] ?>
		} catch (e) {
		}
	});
	<?php } ?>

	(function ($) {

		// Initialize RTE
		initializeRichTextEditors();

		// Slide bars for CMS
		$(document).ready(function () {
			$.slidebars();
			$('input:file, #ModuleTab div.checkbox input:checkbox').not('[data-no-uniform]').uniform();
			$('.sb-toggle-right').click(function () {
				$('header .dropdown').removeClass('open');
			});
		});

		<?php if(empty($this->request->params['filter']) && empty($this->request->data['Log'])) { ?>$('#FilterForm:not(.visible)').hide();<?php } ?>

	})(jQuery);

	// Post execute
	for (var i in postExecuteStack) if (postExecuteStack.hasOwnProperty(i) && typeof postExecuteStack[i] === 'function') {
		postExecuteStack[i]();
	}
</script>

<?php

# Show some debug info
if (Configure::read('debug') >= 2 && !IS_AJAX) {
	echo '<section class="debug" style="padding: 10px; display: ' . (Configure::read('debug') >= 3 ? 'block' : 'none') . ';">';
	echo '<a name="debug"></a>';
	require VECTORCMS_ROOT . 'View' . DS . 'Elements' . DS . 'dev' . DS . 'timer.ctp';
	require VECTORCMS_ROOT . 'View' . DS . 'Elements' . DS . 'dev' . DS . 'sql_dump.ctp';
	echo '</section>';
}
?>

</body>
</html>
