<?php
$notSpeedInsights = (!isset($_SERVER['HTTP_USER_AGENT']) || !stripos($_SERVER['HTTP_USER_AGENT'], 'Speed Insights'));
$this->viewVars['notSpeedInsights'] = $notSpeedInsights;

# Preserve meta data, problem with ob_get_clean;
$metaData = $page;

# Set the title of the document
if (!empty($forceTitle)) {
$documentTitle = $forceTitle;
$documentTitle[] = Configure::read('Website.title');

} else {
$documentTitle = [ Configure::read('Website.title') ];

if (empty($pageTitle)) {
foreach ($sitemap as $submap) {
$pageTitle = activePath($submap['children'], 'Page.selected', 'Page.title_short');

if (!empty($pageTitle)) {
break;
}
}
}
$pageTitle = array_merge((array) $pageTitle, !empty($pageTitleAppend) ? (array) $pageTitleAppend : []);
if (!empty($pageTitle)) {
$documentTitle = array_merge($documentTitle, $pageTitle);
}
$documentTitle = array_reverse($documentTitle);
}
# Render the page
if (!empty($html)) {
ob_start();
eval('?>' . $html);
$pageContent = ob_get_clean();

# No page supplied, show admin login
} else {
header('Location: ' . BACK_BASE_URL);
exit;
}
# Set the class of the body
$layout = strtolower(Inflector::slug($activePage['Layout']['name']));
$bodyClass = "{$layout} locale-{$locale}";
$customBodyClass = $activePage['Page']['body_class'];
if ($customBodyClass != $layout) {
$bodyClass .= ' ' . $customBodyClass;
}
?>
<!DOCTYPE html><?= Configure::read('Website.graph') ? "<!--\n" . Configure::read('Website.graph') . "-->\n" : '' ?>
<html class="<?= $this->Session->read('settings') === null ? 'choose-region' : null?>">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
<title><?= implode(Configure::read('Website.separator'), $documentTitle) ?></title>
<link rel="search" type="application/opensearchdescription+xml" title="<?= implode(Configure::read('Website.separator'), $documentTitle) ?>" href="<?= FRONT_BASE_URL ?>/opensearch.xml" />
<link rel="icon" media="all" type="image/x-icon" href="<?= STATIC_BASE_URL ?>favicon.ico?<?= time() ?>" />
<link rel="shortcut icon" media="all" type="image/x-icon" href="<?= STATIC_BASE_URL ?>favicon.ico?<?= time() ?>" />
<link rel="icon" media="all" type="image/x-icon" href="<?= STATIC_BASE_URL ?>theme/favicons/favicon.png" />
<link rel="shortcut icon" media="all" type="image/x-icon" href="<?= STATIC_BASE_URL ?>theme/favicons/favicon.png" />
<link rel="apple-touch-icon" media="all" sizes="57x57" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-57x57.png" />
<link rel="apple-touch-icon" media="all" sizes="60x60" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-60x60.png" />
<link rel="apple-touch-icon" media="all" sizes="72x72" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-72x72.png" />
<link rel="apple-touch-icon" media="all" sizes="76x76" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-76x76.png" />
<link rel="apple-touch-icon" media="all" sizes="114x114" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-114x114.png" />
<link rel="apple-touch-icon" media="all" sizes="120x120" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-120x120.png" />
<link rel="apple-touch-icon" media="all" sizes="144x144" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-144x144.png" />
<link rel="apple-touch-icon" media="all" sizes="152x152" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-152x152.png" />
<link rel="apple-touch-icon" media="all" sizes="180x180" href="<?= STATIC_BASE_URL ?>theme/favicons/apple-favicon-180x180.png" />
<link rel="icon" type="image/png" media="all" sizes="16x16" href="<?= STATIC_BASE_URL ?>theme/favicons/favicon-16x16.png" />
<link rel="icon" type="image/png" media="all" sizes="32x32" href="<?= STATIC_BASE_URL ?>theme/favicons/favicon-32x32.png" />
<link rel="icon" type="image/png" media="all" sizes="96x96" href="<?= STATIC_BASE_URL ?>theme/favicons/favicon-96x96.png" />
<link rel="manifest" href="<?= STATIC_BASE_URL ?>theme/favicons/manifest.json" />
<link rel="icon" type="image/png" media="all" sizes="192x192" href="<?= STATIC_BASE_URL ?>theme/favicons/android-favicon-192x192.png" />
<meta name="msapplication-TileImage" content="<?= STATIC_BASE_URL ?>theme/favicons/ms-favicon-144x144.png" />
<meta name="msapplication-TileColor" content="#ffffff" />
<meta name="theme-color" content="#000000" />
<link rel="alternate" href="<?= FULL_BASE_URL . $this->here ?>" hreflang="sr-rs" />
<?php echo $this->Seo->renderMetatags($metaTags, $tagDescriptions, $locale) ?>
<?php echo !empty($assets) ? $this->Format->getAssets($assets, 'stylesheets') : '' ?>
<?php if (Configure::read('debug')) {
echo "\n" ?>
<link media="all" rel="stylesheet" type="text/css" href="<?= STATIC_BASE_URL ?>css/debug.css" />
<?php } ?>
<?php
$criticalCssDir = WWW_ROOT . 'css' . DS . 'critical' . DS;
$candidates = array('main.min.css', 'main.css');
foreach($candidates as $candidate) {
if(file_exists($criticalCssDir . $candidate)) { ?>
<style>
<?= file_get_contents($criticalCssDir . $candidate) ?>
</style>
<?	break;	}} ?>
<?php echo $this->Seo->renderHeadEnd($activePage, $seoConfig); ?>
<script> var methodStack = [];</script>
</head>
<body class="<?= $bodyClass ?>">
<?php echo $this->Seo->renderBodyStart($activePage, $seoConfig) ?>
<?= $pageContent ?>
<!--[if lt IE 9]>
<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
<script type="text/javascript">
document.createElement('header');
document.createElement('section');
document.createElement('article');
document.createElement('aside');
document.createElement('nav');
document.createElement('footer');
</script>
<![endif]-->
<script type="text/javascript" language="javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script type="text/javascript" language="javascript" src="/js/intlxForm.js"></script>
<!--[if IE 6]><script src="<?= STATIC_BASE_URL ?>js/belatedPNG.js"></script><script>DD_belatedPNG.fix('.png');</script><![endif]-->
<!--[if lt IE 9]><script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script><![endif]-->
<?= !empty($assets) ? $this->Format->headJS() : "\n"; ?>
<?= !empty($assets) ? $this->Format->getAssets($assets, 'javascripts') : "\n" ?><?= $this->Seo->renderBodyEnd($activePage, $seoConfig) ?>
<?= $this->elementExists('js/scripts') ? $this->element('js/scripts') : null ?><?= $this->elementExists('css/style') ? $this->element('css/style') : null ?>
<?= $this->elementExists('front/cookie_policy') ? $this->element('front/cookie_policy') : null ?><script>for (var method in methodStack) {methodStack[method]();}window.hbs = function (templateName, data, jQueryParse) {var template;if (Handlebars.templates && Handlebars.templates.hasOwnProperty(templateName)) {template = Handlebars.templates[templateName];} else {template = Handlebars.compile(document.getElementById(templateName).innerHTML);}var compiled = template(data).trim();return typeof jQueryParse === 'undefined' || jQueryParse ? jQuery(jQuery.parseHTML(compiled)) : compiled;};</script>
<?php if (Configure::read('Website.google_analytics') && $notSpeedInsights) { ?>
<script type="text/javascript">
(function (i, s, o, g, r, a, m) {
i['GoogleAnalyticsObject'] = r;
i[r] = i[r] || function () {
(i[r].q = i[r].q || []).push(arguments)
}, i[r].l = 1 * new Date();
a = s.createElement(o),
m = s.getElementsByTagName(o)[0];
a.async = 1;
a.src = g;
m.parentNode.insertBefore(a, m)
})(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');

ga('create', '<?= Configure::read('Website.google_analytics') ?>', 'auto');
ga('send', 'pageview');
'use strict';

/**
 * Extremely simple visibility toggle jQuery plugin.
 * Kinda slow, but targeted towards small projects.
 */
(function ($) {
	'use strict';
	$.fn.visibilityToggle = function (name, value) {

		// Get the targets
		var key = 'visibility-toggle-' + name;
		var elements = $(this).find('[data-' + key + ']');

		// Set the proper visibility
		elements.each(function () {
			var values = ($(this).data(key) + '').split(',');
			$(this).toggle(values.indexOf(value + '') !== -1);
		});
	};
})(jQuery, window, document);
</script>
<?php } ?>
</body>
</html>