<?php

// Define all of the field types
$fieldTypes = $this->viewVars['fieldTypes'] = [
	'varchar'  => __('String'),
	'text'     => __('Text'),
	'int'      => __('Integer'),
	'enum'     => __('Dropdown list'),
	'tinyint'  => __('True / False'),
	'datetime' => __('Date and time'),
	'file'     => __('File'),
	'module'   => __('Module')
];

// Define the list of predefined uploads
$uploadTypes = $this->viewVars['uploadTypes'] = [
	'jpeg jpg png gif'          => __('Image'),
	'pdf doc docx xls xlsx odt' => __('Document'),
	'swf flv'                   => __('Flash')
];
$uploadOptions = $this->viewVars['uploadOptions'] = [
	'class'   => 'upload-extensions',
	'empty'   => false,
	'default' => key($uploadTypes)
];

// List of switches
$switches = Module::getSwitches();

// List of available icons
$icons = Module::getIcons();

?>

<div class="header" style="margin-left: 0px">
	<?=
	$this->Format->actions([
		[ 'list', __('List modules'), [ C => $this->request->params['controller'], A => 'index' ] ]
	])
	?>
</div>

<div class="modules form">

	<?php

	// Fix input types.
	if (isset($this->request->data['Module']['Fields'])) {
		foreach ($this->request->data['Module']['Fields'] as $key => $field) {
			if (!isset($field['type'])) {
				$this->request->data['Module']['Fields'][$key]['type'] = 'module';
				$this->request->data['Module']['Fields'][$key]['options']['modules'] = Inflector::tableize($field['name']);

			} else if ($field['type'] == 'file') {
				$this->request->data['Module']['Fields'][$key]['options']['extensions'] = str_replace([ "\r", "\n" ], ' ', $field['options']['extensions']);
				$this->request->data['Module']['Fields'][$key]['helper']['extensions'] = $this->request->data['Module']['Fields'][$key]['options']['extensions'];
			}
		}
	}

	// Parse template with PHP
	if (empty($this->request->data['Module']['Fields'])) {
		$this->request->data['Module']['Fields'] = [ null ];
	}
	$fields = [];
	foreach ($this->request->data['Module']['Fields'] as $i => $field) {
		$fields[] = $this->element('modules/field', [ 'index' => $i, 'field' => $field ]);
	}

	// Echo form
	echo $this->Form->create('Module', [ 'class' => 'tabbed module-manager' ]);

	// Switches
	$switchOptions = [ '<div class="row of switches">' ];
	foreach ($switches as $switch) {
		$switchOptions[] = go($this, $switch['name'], $switch['icon'], $switch['default']);
	}
	$switchOptions[] = '</div>';

	// Define input for icon
	$iconOptions = [
		'options' => array_merge([ null => ' - ' . __('select icon') . ' - ' ], $icons),
		'div'     => [ 'class' => 'input select icon-selector' ],
		'between' => '<a href="#IconSelector" class="nxdialog-trigger"><i id="ModuleIconPreview" class="fa fa-' . @$this->Form->data['Module']['icon'] . '"></i></a>',
	];

	// Define options on each tab
	$this->Form->inputDefaults([ 'adjust' => 'labeled', 'grid-col' => 'md-6' ]);
	$tabs = [
		'Module' => array_merge(
			[
				'<div class="row">',
				$this->Form->input('id'),
				$this->Form->input('name'),
				$this->Form->input('module_group_id'),
				$this->Form->input('icon', $iconOptions),
				$this->Form->input('menu_name'),
				$this->Form->input('paginate'),
				$this->Form->input('page_id'),
				'</div>' ],
			$switchOptions),

		'Fields' => array_merge(
			[
				'<div class="row">',
				$this->Form->input(
					'sort_by',
					[
						'label'   => '<i class="fa fa-fw fa-sort-amount-asc sortby">Ordering</i>',
						'title'   => __('Default ordering for this module'),
						'div'     => 'input clearfix select sortby',
						'adjust'  => 'labeled',
						'options' => [
							'id'       => __('Last item at the top'),
							'ordering' => __('Manual ordering'),
							[ __('From field') => [] ] ],
						'rel'     => $this->Form->value('sort_by') ]),
				'</div>',
				'<ul class="module-fields">' . implode("\n", $fields) . '</ul>',
				'<a href="javascript: ModuleManager.addField()" class="btn btn-primary field-add"><i class="fa fa-plus"></i>' . __('Add field') . '</a>'
			]
		)
	];
	$this->Form->inputDefaults([]);

	function go($g, $field, $icon, $default = false) {
		return $g->Form->input(
			$field,
			[
				'type'    => 'checkbox',
				'default' => $default,
				'label'   => false,
				'div'     => 'col-md-2',
				'before'  => '<div class="switch checkbox"><label><i class="fa fa-fw fa-' . $icon . '"></i><span>' . __(Inflector::humanize($field)) . '</span>',
				'after'   => '</label></div> ' ]
		);
	}

	$menu = [];
	$content = [];
	foreach ($tabs as $label => $data) {
		$id = Inflector::classify($label) . 'Tab';
		$menu[] = $this->Html->tag('li', $this->Html->link(__($label), '#' . $id));
		$content[] = $this->Html->tag('div', implode($data), [ 'id' => $id, 'class' => 'tab multiple' ]);
	}

	# Close the form
	echo '<ul class="nav nav-tabs">' . implode($menu) . '</ul>' . implode($content);
	echo $this->Form->close(__('Save module'));
	?>
	<script type="text/javascript">

		var ModuleManager = {

			fieldIndex: <?= sizeof($fields) + 1 ?>,

			/**
			 * DOM elements
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			__: {

				form: $('#ModuleFormForm'),

				iconSelect: $('#ModuleIcon'),
				iconPreview: $('#ModuleIconPreview'),

				sortBy: $('#ModuleSortBy'),
				sortByOptions: $('#ModuleSortBy').children('optgroup'),

				fields: $('.module-fields')
			},


			/**
			 * Add a field
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			addField: function () {
				ModuleManager.fieldIndex++;

				// Append the field
				this.__.fields.append(
					'<?= preg_replace('/\s+/', ' ', str_replace('!#!', "' + ModuleManager.fieldIndex + '", $this->element('modules/field'))) ?>'
				);
				this.__.fields.find('.field-type').change();

				// Scroll to the bottom of the page
				$('html,body').scrollTop($(document).height() * 10);
			},


			/**
			 * Remove a field
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			removeField: function (element) {
				$(element).closest('li').remove();
				return ModuleManager.refresh();
			},


			/**
			 * Refresh the form
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			refresh: function (event) {

				// Get current ordering and remove all options
				var ordering = ModuleManager.__.sortBy.val();
				ModuleManager.__.sortByOptions.empty();
				ModuleManager.__.sortBy.val('id');

				// Find the fields for sorting
				var sortOptions = ModuleManager.__.sortByOptions;
				ModuleManager.__.fields.find('.field-name').each(function () {
					var field = $(this);

					// Get the field name and type
					var fieldName = field.val().replace(/(.)([A-Z])/g, '$1_$2').replace(/ /g, '').toLowerCase();
					var fieldType = field.closest('li').attr('rel');

					// Check if the field is a candidate for sorting
					switch (true) {
						case fieldType == 'file':
						case fieldType == 'module':
						case fieldType == 'tinyint':
						case fieldName.match(/_set$/):
							return;
					}

					// Append the field to the list of options
					sortOptions.append($('<option>').val(fieldName).text(field.val()));

				});
				ModuleManager.__.sortBy.val(ordering);

				// Prevent default
				return ModuleManager.prevent(event);
			},


			/**
			 * Initilize
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			init: function () {

				// Refresh ordering before submiting the form
				this.__.form.submit(function () {
					ModuleManager.refresh();
					return true;
				});

				// Change the module icon preview on change and key up
				var iconPreview = this.__.iconPreview;
				this.__.iconSelect.change(function () {
					iconPreview.attr('class', 'fa fa-' + $(this).val());

				}).keyup(function () {
					$(this).change();
					return true;
				}).keyup();

				// Change field type
				$(document).on('change', '.module-fields .field-type', function () {
					var item = $(this).closest('li');
					var name = item.find('.field-name');
					var module = item.find('.field-module');

					// Get the selected tpe
					var type = $(this).val();
					item.attr('rel', type);

					// Default
					var required = item.find('div.side.required');
					required.show();
					module.hide();
					name.show();

					// Specific for type module
					switch (type) {
						case 'module':
							name.hide();
							module.show();
							module.change();
							break;

						case 'file':
						case 'tinyint':
							required.hide();
							break;
					}

					// Show options for selected type only
					var options = item.find('.field-options');
					options.children('.input').hide();
					options.children('.input.type-' + type).show();
					options.children('.input.type-all').show();

					// Set the proper icon
					var icon = 'asterisk';
					var map = {
						'varchar': 'font',
						'text': 'paragraph',
						'int': 'italic',
						'enum': 'list',
						'tinyint': 'check-square-o',
						'datetime': 'calendar',
						'file': 'cloud-upload',
						'module': 'magic',
					};
					if (typeof map[type] != 'undefined') {
						icon = map[type];
					}
					item.find('i.type').attr('class', 'fa fa-' + icon + ' type');

					// Focus on the field name
					item.find('.field-name').select().focus();
				});

				// Refresh on field name change
				$(document).on('blur', '.module-fields .field-name', ModuleManager.refresh);
				$(document).on('change', '.module-fields .field-name', ModuleManager.refresh);

				// Predefined file extensions
				$(document).on('change', '.file-extension select', function () {
					$(this).closest('.file-extension').find('input').val($(this).val());
				});
				$(document).on('keyup', '.file-extension input', function () {
					$(this).closest('.file-extension').find('select').val('').val($(this).val());
				});

				// Module type
				$(document).on('change', '.field-module', function () {
					$(this).closest('li').find('.field-name').val($(this).val());
				});
			},


			/**
			 * Prevent the default for the event
			 * ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~     ~    ~  ~  ~ */
			prevent: function (event) {
				if (typeof event == 'Object') event.preventDefault();
				return false;
			}

		};

		// Initialize components that must wait for the document to load
		$(document).ready(function () {

			// Show the proper tab with error
			var error = $('.form-input-error-message');
			if (error.length) {
				var tab = $(error[0]).closest('.tab').prevAll('.tab').length;
				$('.nav-tabs > li:eq(' + tab + ') a').click();
			}

			// Allow sorting
			$('.module-fields').sortable({
				axis: 'y',
				distance: 35
			});

			// Refresh
			ModuleManager.init();
			ModuleManager.refresh();
			$('.module-fields .field-type').change();
		});

		// Tabs
		$('.nav-tabs a').click(function (event) {
			$('.tab').hide();
			$($(this).attr('href')).show();
			$(this).closest('li').addClass('active').siblings().removeClass('active');

			return ModuleManager.refresh(event);
		}).filter(':first').click();
	</script>
</div>

<?= $this->Html->script('helpers/modulevalidation.js', [ 'inline' => false, 'once' => true ]) ?>

<script src="/js/angular/angular.js"></script>
<script src="/js/angular/angular-route.js"></script>
<script src="/js/angular/angular-resource.js"></script>

<script type="text/javascript">

	angular.element(document).ready(function () {
		angular.bootstrap(document, ['ngCMS']);
	});

	// Declare app level module which depends on views, and components
	var ngCMS = angular.module(
		'ngCMS', [
			'ngResource',
			'IconController']);

	// Controller that handles the filter
	angular.module('IconController', [])
		.controller('IconController', ['$scope', function ($scope) {

			// Selected item
			$scope.empty = false;
			$scope.term = '';
			$scope.selected = -1;

			// Get the list of icons
			var icons = <?= json_encode(array_values($icons)) ?>;
			$scope.icons = [];
			for (var i in icons) {
				$scope.icons[i] = {
					i: parseInt(i),
					name: icons[i],
					visible: true
				}
			}

			// Select an icon
			$scope.select = function (icon, event) {
				$('#ModuleIcon').val(icon.name).change();
				nxDialog.hide();

				event.preventDefault();
				return false;
			};

			// Filter the results
			$scope.filter = function () {
				$scope.empty = true;
				for (var i in icons) {
					$scope.icons[i].visible = !$scope.term || $scope.icons[i].name.match(new RegExp($scope.term, 'i'));
					$scope.empty = $scope.empty || $scope.icons[i].visible;
				}
			};

			// Mark an icon as active
			$scope.mark = function (icon) {
				$scope.selected = icon.i;
			};

			// Select icon by keyboard
			$scope.move = function (code) {
				switch (code) {
					case 37:
						return moveBy(-1);
					case 38:
						return moveBy(-20);
					case 39:
						return moveBy(+1);
					case 40:
						return moveBy(+20);

					case 13:
						if ($scope.selected >= 0 && $scope.selected < $scope.icons.length) {
							var icon = $scope.icons[$scope.selected];
							if (icon.visible) {
								$scope.select(icon);
								return;
							}
						}

						// Get the first visible
						for (var i in $scope.icons) {
							if ($scope.icons[i].visible) {
								$scope.selected = $scope.icons[i].i;
								return;
							}
						}
				}
			};

			// Find next visibile
			moveBy = function (delta) {
				var len = $scope.icons.length;
				if ($scope.selected == -1) {
					$scope.selected = 0;
					return;
				}

				var p = 0;
				var sign = delta > 0 ? 1 : -1;
				for (var i = $scope.selected + sign; i < len && i >= 0; i += sign) {
					var icon = $scope.icons[Math.max(0, Math.min(len - 1, i))];

					// Only iterate over visible
					if (icon.visible) {
						p++;
					}

					// Select if reached it
					if (p == Math.abs(delta)) {
						$scope.mark(icon);
						break;
					}
				}
			}
		}]);

</script>

<div id="IconSelector" style="display:none">
	<div class="icon-picker" ng-controller="IconController">
		<form class="icon-picker-header">
			<div class="input">
				<input ng-model="term" ng-change="filter()" ng-keypress="move($event.keyCode)" placeholder="<?= __('Search for an icon') ?>" />
			</div>
		</form>

		<ul class="icon-picker-list clearfix">
			<li ng-repeat="icon in icons" class="{{ icon.i == selected ? 'selected' : '' }}" ng-show="icon.visible" ng-mousemove="mark(icon)">
				<a ng-click="select(icon, $event)" href="#{{ icon.name }}" title="{{ icon.name }}"><i class="fa fa-fw fa-{{ icon.name }}"></i></a>
			</li>
		</ul>

		<p ng-show="empty" class="empty well"><?= __('No icons have been found for the term') ?>
			'<b>{{ term }}</b>'.</p>
	</div>
</div>

<script type="text/javascript">

	$(document).ready(function () {

		// Trigger the icon picker
		$('.nxdialog-trigger').nxDialog({

			// Focus on the filter
			onInit: function (dialog) {
				setTimeout(function () {
					dialog.find('input').select().focus();
				}, 200);
			}
		});
	});

</script>

