<?php

	$model = ClassRegistry::init($modelClass);
	$modelPlugin = strtolower($model->plugin);

	// Get the groups
	$groups = ClassRegistry::init('Module')->getGrouped(true);

	// Switches
	$switches = Module::getSwitches();

	// Pack
	foreach($groups as $g => $group) {

		foreach($group['modules'] as $i => $module) {

			// Set the model
			$module['Model'] = ClassRegistry::init($module['Module']['name']);

			// Proper name
			$module['Module']['name'] = Inflector::humanize(Inflector::tableize($module['Module']['name']));
			if($module['Module']['is_single_item']) {
				$module['Module']['name'] = Inflector::singularize($module['Module']['name']);
			}

			// Set the switches
			$module['switches'] = $switches;
			foreach($module['switches'] as $name => $switch) {
				$module['switches'][$name]['on'] = !empty($switch['field'])
					? !empty($module['Model']->schema($switch['field']))
					: !empty($module['Module'][$switch['name']]);
			}

			$groups[$g]['modules'][$i] = $module;
		}
	}

?>

<div class="main-content">
	<div class="header">
		<?php
			Timer::start('Buttons'); {

				# Other actions
				echo $this->Format->actions(
					array(

						# Add new
						array('plus', __('Add new module'), array(P => $modelPlugin, C => $controller, A => 'add'), array('class' => 'btn btn-success')),

						# Refresh menu
						array('refresh', __('Refresh menu'), 'javascript: location.reload();', array('class' => 'btn btn-default')),

						# Add new group
						array('folder-open', __('New group'), '#EditGroup', array('class' => 'btn btn-default group-edit-trigger', 'data-id' => '', 'data-name' => ''))),

					# Quick filter
					array('<input type="text" id="QuickFilter" value="' . (!empty($this->request->data[$model->alias]['_keyword']) ? $this->request->data[$model->alias]['_keyword'] : null) . '" />')
				);

			} Timer::end('Buttons');

	   ?>
	</div>

	<div class="clear"></div>

	<div class="cms_modules index clearfix">
		<ul class="groups">
			<?php foreach($groups as $group) { ?>
				<li data-type="group" data-id="<?= $group['id'] ?>" class="group <?= empty($group['id']) ? 'sortable-disabled' : 'sortable-enabled' ?>">

					<?php if(!empty($group['name'])) { ?>
						<a href="#delete" class="group-option group-delete" data-id="<?= $group['id'] ?>"><i class="fa fa-trash-o"></i></a>
						<a href="#EditGroup" class="group-option group-modify group-edit-trigger" data-id="<?= $group['id'] ?>" data-name="<?= $group['name'] ?>"><i class="fa fa-pencil"></i></a>
						<strong data-group-label-id="<?= $group['id'] ?>"><?= $group['name'] ?></strong>
					<?php } else { ?>
						<strong class="invisible">&nbsp;</strong>
					<?php } ?>

					<ul class="modules">
						<?php foreach($group['modules'] as $module) { ?>
							<li data-type="module" data-id="<?= $module['Module']['id'] ?>" class="clearfix module sortable-enabled">
								<a href="<?= Router::url(array(A => 'edit', $module['Module']['id'])) ?>">
									<span class="icon">
										<?= $module['Model']->getMenuIcon($module) ?>
									</span>

									<?= $module['Model']->getMenuName($module) ?>

									<ul class="switches">
										<?php foreach($module['switches'] as $switch) { ?>
											<li class="<?= $switch['on'] ? 'on' : 'off' ?>">
												<i class="fa fa-fw fa-<?= $switch['icon'] ?>" title="<?= __(Inflector::humanize($switch['name'])) . ': ' . ($switch['on'] ? __('YES') : __('NO')) ?>"></i>
											</li>
										<?php } ?>
									</ul>
								</a>
							</li>
						<?php } ?>
					</ul>
				</li>
			<?php } ?>
		</ul>
	</div>
</div>

<div id="EditGroup" style="display:none">
	<form>
		<br /><br />

		<div class="row">
			<div class="col-xs-12 text-center">
				<div class="input">
					<input name="id" class="group-edit-id" type="hidden" />
					<input name="name" placeholder="<?= __('Name of the group') ?>" class="group-edit-name" autocomplete="off" />
				</div>
			</div>
		</div>

		<br /><br />

		<div class="row">
			<div class="col-xs-12 text-center">
				<button class="btn btn-primary btn-center group-edit"><i class="fa fa-fw fa-save"></i> <?= __('Submit') ?></button>
			</div>
		</div>
	</form>
</div>

<script type="text/javascript">
	$(document).ready(function() {

		// Reorder categories and modules
		$('.cms_modules ul.groups').sortable({
			distance: 35,
			handle: 'strong',
			items: '> li.sortable-enabled',
			stop: function() {
				reorder();
			}
		});
		$('.cms_modules ul.modules').sortable({
			distance: 35,
			connectWith: '.cms_modules ul.modules',
			stop: function() {
				reorder();
			}
		});

		// Add group
		$('.group-edit-trigger').nxDialog({

			// Focus on the input
			onInit: function(dialog, element) {
				var groupId = dialog.find('.group-edit-id');
				var groupName = dialog.find('.group-edit-name');

				// Set the defaults
				groupId.val(element.data('id'));
				groupName.val(element.data('name'));

				// Focus on the input field
				groupName.focus().select();
			}
		});

		// Action: add group
		$('.group-edit').click(function(event) {
			var element = $(this);

			// Validate name
			var id = $('.group-edit-id').val();
			var name = $('.group-edit-name').val();
			if(name == '') {
				alert(<?= json_encode(__('Please select group name')) ?>);

			// Run
			} else {
				nxDialog.hide();
				fullAjax(
					'<?= Router::url(array(A => 'group')) ?>',
					element.closest('form').serialize(),
					function() {

						// Update the view
						var group = $('ul.groups > li[data-id=' + id + ']');
						group.find('strong').text(name);
						group.find('.group-edit-trigger').data('name', name);

						// Refresh for new group
						if(!id) {
							location.reload();
						}
					}
				);
			}

			return !!event.preventDefault();
		});

		// Delete group
		$('a.group-delete').click(function(event) {
			if(confirm(<?= json_encode('Are you sure you want to delete this module group?') ?>)) {
				var post = { 'delete': $(this).data('id') };

				fullAjax('<?= Router::url(array(A => 'group')) ?>', post, function() {
					var group = $('ul.groups li.group[data-id=' + post.delete + ']');

					// Reload if there where modules, else just remove
					if(group.find('li.module').length) {
						location.reload();
					} else {
						group.remove();
					}
				});
			}

			return !!event.preventDefault();
		});

	});

	function reorder() {
		var data = [];

		// Handle groups
		var groups = $('ul.groups [data-type="group"]');
		groups.each(function(groupIndex) {
			var group = $(this);

			// Put modules
			var modules =[];
			group.find('[data-type="module"]').each(function(moduleIndex) {
				modules.push({
					id: $(this).data('id'),
					module_group_id: group.data('id'),
					ordering: groupIndex * 10000 + moduleIndex + 1
				});
			});

			// Set the data
			data.push({
				id: group.data('id'),
				ordering: groupIndex,
				modules: modules
			});
		});

		// Send
		fullAjax('<?= Router::url(array(A => 'reorder')) ?>', { reordering: data }, null);
	}

</script>
