<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.console.libs.templates.views
 * @since         CakePHP(tm) v 1.2.0.5234
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

Timer::start('Newsletter');
$ignore = [];
$sideFNames = [ 'name', 'parent_id', 'category_id', 'page_id', 'ordering', 'is_active', 'is_deleted', 'approval_status' ];
$hiddenFields = [ 'module_id', 'list' ];

if (!isset($model)) {
	$model = ClassRegistry::init($modelClass);
}

# Set commonly used variables
$polyglot = !empty($model->polyglotFields);
$datetimepicker = false;
$languages = Configure::read('Config.Languages');

# Check if form has upload
$formType = null;
foreach ([ 'hasOne', 'hasMany' ] as $association) {
	foreach ($model->$association as $related) {
		if ($related['className'] == 'Upload') {
			$formType = 'file';
			break(2);
		}
	}
}

echo $this->Form->create(
	$modelClass,
	[
		'url'      => [ C => $controller, A => 'send' ],
		'class'    => 'tabbed',
		'type'     => $formType,
		'onsubmit' => 'dataSubmited = true; $(".is-translated").attr("disabled", false); return true;' ]
);

$sidefields = [];
# Iterate over all fields in the model
foreach ($model->schema(true) as $field => $params) {
	# Special statuses of the field
	$invisible = in_array($field, $model->invisible) || in_array($field, $hiddenFields);
	$locked = in_array($field, $model->locked);
	$set = substr($field, -4) == '_set';

	# Some common variables
	//~ $fieldname = preg_replace('~(_id|__.*)$~', '', $field);
	$options = !empty($fieldOptions[$field]) ? $fieldOptions[$field] : [];

	# Skip invisible and locked fields, leave set for later
	if (!$invisible && !$locked && !$set) {
		$inputField = $this->Form->getField($field, $params, $options, $model);
		if ($inputField) {
			if (!in_array($field, $sideFNames)) {
				$fields[] = $inputField;
			} else {
				$sidefields[] = $inputField;
			}
		}
	}
}

$showSidebar = true;

echo $this->element('form/actions', [ 'showSideBar' => $showSidebar ]);
echo $this->element('form/mailing/side_elements', [ 'model' => $model, 'sidefields' => $sidefields ]);

?>
<div class="<?= $plural ?> form with-sidebar" <?= !$showSidebar ? 'style="margin-left:0px"' : '' ?>>

	<div style="left:-5000px;position:absolute;">
		<div class="map-picker" id="map">
			<h5><?= __('Please choose coordinates with left click') ?></h5>
			<div class="map" id="gMap" style="width:600px;height:400px;">&nbsp;</div>
			<div class="input">
				<input id="mapInput" class="input-block-level" type="text">
				<button id="mapOkButton" type="button" class="btn btn-primary pull-right">OK
				</button>
			</div>
		</div>
	</div>

	<?php
	# Always begin with id
	echo $this->Form->input('id');

	# Sets
	if (!empty($model->hasSet)) {
		foreach ($model->hasSet as $association => $params) {
			$properties = [
				'label' => __(Inflector::pluralize(Inflector::humanize($association))),
				'after' => '',
				'empty' => true,
				'class' => 'setter',
				'value' => 0,
				'type'  => 'select',
				'name'  => 'data[' . $association . '][]',
				'div'   => 'input select set',
				'id'    => false
			];
			if (!empty($this->request->data[$association])) {
				foreach ($this->request->data[$association] as $item)
					if (!empty($item)) {
						$after = array_merge(
							$properties,
							[
								'div'   => false,
								'class' => '',
								'label' => false,
								'value' => $item['id'],
								'after' => '' ]
						);
						$properties['after'] .= $this->Form->input($association . '.' . $association, $after);
					}
			}

			$properties = array_merge($properties, isset($params['params']) ? $params['params'] : []);
			$fields[] = $this->Form->input("{$association}.{$association}", $properties);
		}
	}

	# Uploads
	$activeLocale = Configure::read('Config.language');
	foreach ([ 'hasOne', 'hasMany' ] as $type) {
		foreach ($model->$type as $alias => $association) {
			if ($association['className'] == 'Upload' && !isset($model->{$type}["{$alias}__{$activeLocale}"])) {
				if ($alias == 'MetaImages')
					continue;
				if ($locale = getLocale($alias)) {
					$polyglot = true;
					$meta['locale'] = $locale;
				}

				# Add fields
				$options = [
					'comment' => $association['comment']
				];
				$fields[] = $this->Form->upload($alias, $options);
			}
		}
	}

	# echo polyglot
	if ($polyglot && count(Configure::read('Config.Languages')) > 1) {
		echo $this->Form->polyglotTabs();
	}
	?>
	<ul class="nav nav-tabs">
		<li><a href="#ContentTab"><?= __('Email template') ?></a></li>
		<li><a href="#ReceiversTab"><?= __('Receivers') ?></a></li>
	</ul>

	<div class="tab" id="ContentTab">
		<?= join($fields) ?>
	</div>
	<?php if (isset($receivers)) { ?>
		<div class="tab" id="ReceiversTab">
			<?= $this->element('form/mailing/receivers', [ 'receivers' => $receivers, 'receiverModule' => $receiverModule ]) ?>
		</div>
	<?php } ?>

	<script type="text/javascript">

		$('.selectable .input-field').find('input, texteto area, select, .other').change(function () {
			$(this).closest('.selectable').find('span.label :checkbox').attr('checked', true);
		});


		<?php if(!empty($this->request->params['multiple'])) { ?>
		$('.is-translated').attr('checked', true).css('opacity', 0.3);
		$('.is-translated').change(function () {
			$(this).prev().prev().val(1);
			var hidden = $(this).prev().prev();
			if (!$(this).is(':checked') && hidden.val() == 1 && $(this).css('opacity') != 1) {
				$(this).attr('checked', true).css('opacity', 1);
				hidden.val(1);

			} else if (!$(this).is(':checked') && hidden.val() == 1 && $(this).css('opacity') == 1) {
				$(this).css('opacity', 1);
				hidden.val(1);

			} else {
				$(this).css('opacity', 0.3);
				hidden.val(0);
			}
		});
		<?php } ?>

		<?php if(!empty($model->hasSet)) { ?>
		$('div.input.select.set select:not(.setter)').change(function () {
			if (!$(this).val()) $(this).remove();
		});
		$('div.input.select.set select.setter').change(function () {
			if ($(this).val()) {
				var value = $(this).val();
				$(this).val(0).clone()
					.val(value)
					.change(function () {
						if (!$(this).val()) $(this).remove();
					})
					.appendTo($(this).parent());
			}
		});
		<?php } ?>

		<?= !empty($script) ? $script : '' ?>

		/* Alert administrator before leaving page */
		var dataSubmited = false;
		var dataHasChanged = false;
		$('div.form form input, div.form form select, div.form form textarea').change(function () {
			dataHasChanged = true;
		});
		window.onbeforeunload = function () {
			return dataHasChanged && !dataSubmited ? "<?= __('Leave this page without saving?') ?>" : null;
		};

		/* Save with Ctrl+S */
		ajax = false;
		saving = false;
		ajaxSave = function () {
			if (!saving) {
				ajax = true;
				saving = true;
				$('Form#<?= $modelClass ?>FormForm').submit();
			}
			return false;
		};
		$(document).keydown(function (e) {
			if (e.ctrlKey && e.keyCode == 83) {
				ajaxSave();
				return false;
			}
		});
		$(document).ready(function () {
			$('Form#<?= $modelClass ?>FormForm').submit(function () {
				if (ajax) {
					ajax = false;
					$.post(
						$(this).attr('action'),
						$(this).serialize(),
						function (response) {
							if (response) {
								alert('<?= __('There was en error:') ?>\n' + response);
							}
							saving = false;
						}
					);
					return false;
				}

				return true;
			});
		});

		/* Codemirror */
		$('textarea.cm-css, textarea.cm-js, textarea.cm-full').each(function (i, area) {
			var type = $(area).attr('class').replace(/^.*cm-([a-z]+).*$/, '$1');
			var _parser = "parse" + type + ".js";
			var _stylesheet = "/plugins/codemirror/css/" + type + "colors.css";
			if (type == 'full') {
				_parser = ["parsexml.js", "parsexml.js", "parsecss.js", "parsejs.js", "parsehtml.js", "tokenizephp.js", "parsephp.js", "parsephphtmlmixed.js"];
				_stylesheet = ["/plugins/codemirror/css/xmlcolors.css", "/plugins/codemirror/css/jscolors.css", "/plugins/codemirror/css/csscolors.css", "/plugins/codemirror/css/phpcolors.css"];
			}
			var editor = CodeMirror.fromTextArea($(area).attr('id'), {
				height: "dynamic",
				path: "/plugins/codemirror/js/",
				tabMode: 'spaces',
				indentUnit: 4,
				saveFunction: ajaxSave,
				parserfile: _parser,
				stylesheet: _stylesheet
			});
		});

		/* Page Select */
		$('.page-select').change(function () {
			var page = $(this).val();
			if (page == '') {
				$(this).prev().val('');
			} else {
				$(this).prev().val('page:' + page);
			}
		});

		/* File upload functions */
		<?php echo $this->Html->script([ 'jquery/jquery.iframe-transport', 'jquery/jquery.fileupload' ], false) ?>
		$(function () {
			$('input.new-upload:not(.activated)').each(function (i, upload) {
				var fileList = $(this).closest('.file-list');
				$(upload).addClass('activated').fileupload({
					dataType: 'html',

					dropZone: fileList.children('.file-drop-zone'),

					add: function (e, data) {
						data.submit();
						for (var i = 0; i < data.files.length; i++) {
							var file = data.files[i];
							var filename = file.fileName ? file.fileName : file.name;

							if (!$(this).is('[multiple]')) {
								$(this).remove();
							}

							fileList.children('.file-new')
								.append($('<div class="file-new-progress">')
									.attr('rel', filename)
									.append($('<span>').text(filename))
									.append($('<div class="file-new-progress-bar">')
										.append($('<div>'))));
						}
					},

					progress: function (e, data) {
						var item = $(this).closest('li');
						var percent = parseInt(data.loaded / data.total * 100, 10);

						var filename = data.files[0].fileName ? data.files[0].fileName : data.files[0].name;
						var bar = $('.file-new-progress[rel="' + filename + '"] .file-new-progress-bar div');

						bar.css('width', percent + '%');
					},

					done: function (e, data) {
						fileList.children('ul').prepend(data.result);

						if (!$(this).is('[multiple]')) {
							$(this).remove();
						}

						var filename = data.files[0].fileName ? data.files[0].fileName : data.files[0].name;
						$('.file-new-progress[rel="' + filename + '"]').remove();
					}
				});
			});

			$('.file-list ul').sortable({
				axis: 'y',
				handle: '.file-preview',
				placeholder: "ui-state-highlight"
			});
		});

		/* Resubmit file */
		$('form').on('click', '.file-change', function () {
			$(this).closest('li').find('input[type=file]').toggle();
			return false;
		});

		/* Delete file */
		$('form').on('click', '.file-delete', function () {
			var li = $(this).closest('li');
			var img = $('.file-preview img:first', li);
			var input = $('input.delete', li);

			var marked = input.val();
			if (marked == 0) {
				input.val(1);

				var mask = $('<div class="file-mask">').css({
					width: img.width(),
					height: img.height()
				});
				img.after(mask);
				mask.fadeIn('fast');
				li.find('.file-details').fadeOut();

			} else {
				input.val(0);

				img.next('.file-mask').fadeOut('medium', function () {
					$(this).remove();
				});
				li.find('.file-details').fadeIn();
			}

			return false;
		});


		/* Expand/Colapse file list */
		$('form .file-list ul').each(function (i, list) {
			if ($(list).height() == 246) {
				$(list).closest('.file-list').find('.icon-down').show();
			}
		});

		$('form').on('click', '.icon-resize-full', function () {
			var list = $(this).closest('.file-list').find('ul:first');
			list.attr('style', 'max-height:3000px');

			$(this)
				.attr('title', '<?= __('Colapse') ?>')
				.removeClass('icon-resize-full')
				.addClass('icon-resize-small');
			return false;
		});

		$('form').on('click', '.icon-resize-small', function () {
			var list = $(this).closest('.file-list').find('ul:first');
			list.removeAttr('style');

			$(this)
				.attr('title', '<?= __('Expand') ?>')
				.removeClass('icon-resize-small')
				.addClass('icon-resize-full');
			return false;
		});

		/* Date picker */
		$('.date-time-picker').datetimepicker({
			showSecond: true,
			timeFormat: 'HH:mm:ss',
			stepHour: 1,
			stepMinute: 1,
			stepSecond: 1,
			addSliderAccess: true,
			sliderAccessArgs: {touchonly: false}
		});

		/* Some tabs */
		$('.nav-tabs a').click(function () {
			$('.tab').hide();
			$($(this).attr('href')).show();
			$(this).closest('li').addClass('active').siblings().removeClass('active');
			$('.add-field').toggle($('#FieldTab').is(':visible'));
			return false;
		});
		$('.nav-tabs:not(.polyglot-tabs) a:first').click();

		/* Inteconnecting with other modules */
		InputFieldParseCoutner = {};
		InputFieldParser = {
			list: null,

			// Get jQuery object from HTML
			parseTemplate: function (template) {
				return $(jQuery.parseHTML('<div>' + template + '</div>')[0]);
			},

			// Return references to elements inside HTML
			add: function (selector, fields, values) {
				if (values == null) values = {};

				var dom = {};
				var item = $('<li>');
				var list = $(selector);

				// Remove button
				var remove = $('<a href="javascript: void(0)" class="btn btn-error btn-micro remove-related">').html('<i class="icon icon-remove"></i> <?= __('Remove') ?>');
				remove.click(function () {
					$(this).parent().remove();
				});
				remove.appendTo(item);

				// Over each input field
				$.each(fields, function (name, template) {

					// Parse the template and append it to the list item
					template = template.replace(/###/g, list.children().length + 1);
					template = InputFieldParser.parseTemplate(template);
					item.append(template);

					// Append to our list
					dom[name] = template.find('[id$=' + name + ']');
				});

				// Apply values
				for (var rel in values) {
					$('[rel=' + rel + ']', item).val(values[rel]);
				}

				// Append to the list
				$(list).append(item);

				return dom;
			}
		};

		/* Sorting for related models */
		$('.related > ul').sortable({
			axis: 'y',
			placeholder: 'ui-state-highlight'
		});
	</script>

	<?= $this->Form->close('newsletter') ?>

</div>
<?php Timer::end('Newsletter') ?>
