<?php

$page404 = $this->Form->value('Page.id') === '1';
$module = $this->Form->value('Page.type') === 'Module' ? $this->Form->value('Page.module_id') : false;

# Start the form
echo $this->Form->create(
	'Page',
	[
		'id'       => 'PageForm',
		'url'      => [ C => 'pages', A => 'form' ],
		'type'     => 'file',
		'class'    => 'tabbed',
		'onsubmit' => 'dataSubmited = true; $(".is-translated").attr("disabled", false); return true;' ]
);

# Get the method for drawing optional polyglot fields
$polyglot = ClassRegistry::init('Page')->_schema['title']['polyglot'];
$polyglotMethod = $polyglot ? 'polyglots' : 'input';

?>

<?= $this->element('form/actions', [ 'showPolyglotTabs' => $polyglot ]) ?>

<div class="col-md-4 col-lg-2">
	<div class="side-bar">
		<div class="form-header">

			<?php if (!$page404) { ?>
				<?php if ($module) { ?>
					<?= $this->Form->input('type', [ 'type' => 'hidden', 'value' => Page::TYPE_MODULE ]) ?>
				<?php } else { ?>
					<div class="type">
						<?= $this->Form->choose('type', [ 'label' => __('Page type'), 'options' => [
							Page::TYPE_PAGE    => [ 'file-text-o', __('Page') ],
							Page::TYPE_WRAPPER => [ 'folder-open-o', __('Wrapper') ],
							Page::TYPE_LINK    => [ 'link', __('Link') ]
						] ]) ?>
					</div>
				<?php } ?>
			<?php } ?>

			<?php

			// Print parent page for non-error pages
			echo !$page404
				? $this->Form->input('parent_id', [ 'adjust' => 'filer-simple' ])
				: null;

			// Always print layout which to use
			echo $this->Form->input('layout_id', [ 'options' => $layouts, 'adjust' => 'filer-simple' ]);

			// Select visibility and category options
			if (!$module && !$page404) {
				echo $this->Form->input('is_visible', [ 'label' => __('Show in menu'), 'adjust' => 'checkbox', 'side' => true ]);
				// echo $this->Form->input('is_category', [ 'label' => __('Act as category'), 'adjust' => 'checkbox', 'side' => true ]);
			}
			?>
		</div>
	</div>
</div>

<div class="col-md-9 col-lg-10">
	<div class="pages form with-sidebar">

		<?= $this->Form->input('id') ?>

		<ul class="nav nav-tabs">
			<li><a href="#DataTab"><?= __('Data') ?></a></li>
			<?php if (!$page404) { ?>
				<li><a href="#SeoTab"><?= __('SEO') ?></a></li>
			<?php } ?>
		</ul>

		<div class="tab multiple" id="DataTab">
			<div class="form-header">
				<div class="basic">
					<?php

					// Print if this is not a 404 page
					if (!$page404) {

						// Show titles for non-module pages
						if (!$module) {
							echo $this->Form->$polyglotMethod('title', [ 'label' => __('Page title'), 'adjust' => 'filer' ]);
							echo $this->Form->$polyglotMethod('title_short', [ 'label' => __('Shorten title'), 'adjust' => 'filer' ]);
							echo $this->Form->$polyglotMethod('summary', [ 'label' => __('Page Summary'), 'adjust' => 'filer' ]);


							// Just remember the ID of the module
						} else {
							echo $this->Form->input('module_id', [ 'type' => 'hidden' ]);
						}

					}

					# Url
					if (!empty($pages)) {
						$url = preg_replace('~^page:(.*)$~', '$1', $this->Form->value('url'));
						$select = $this->Form->select('PageSelect.value', $pages, [ 'class' => 'page-select', 'value' => $url ]);
						// $target = '<br /><br />' . $this->Form->checkbox('url_target') . '<label>' . __('Open in new tab') . '</label>';

						echo $this->Form->input('url', [ 'div' => [ 'style' => 'display:none' ], 'after' => $select ]);

						echo $this->Form->input('url_target', [
							'label'  => __('Open in new tab'),
							'adjust' => 'half',
							'div'    => [
								'style' => 'display: none' ]
						]);
					}
					?>
				</div>
				<div class="clear"></div>
			</div>

			<div class="form-upload form-image">
				<?= $this->Form->upload('Image') ?>
			</div>

			<div class="form-upload form-image">
				<?= $this->Form->upload('ListImage') ?>
			</div>

			<div class="form-body">
				<?= $this->element('form/content') ?>
			</div>

		</div>

		<?php if (!$page404) { ?>
			<div class="tab multiple" id="SeoTab">
				<div class="form-meta">
					<?= $this->element('form/meta') ?>
				</div>
			</div>
		<?php } ?>

		<?= $this->Form->button('Apply', [ 'class' => 'btn btn-default', 'name' => 'apply-btn', 'value' => 'Apply', 'style' => 'display:none' ]); ?>

		<?= $this->Form->close() ?>

		<script type="text/javascript">

			$(function () {

				// Control the fields in the form by the selection of the page type
				$("#PageType").change(function () {
					$(".nav-tabs li:eq(1)").hide();
					$(".form-meta, .form-body, .form-upload").hide();
					$("#PageLayoutId, #PageUrl, #PageUrlTarget, #PageIsVisible, #PageIsCategory").closest("div.input").hide();
					
					switch ($(this).val()) {
						case "<?= Page::TYPE_PAGE ?>":
							$(".nav-tabs li:eq(1)").show();
							$(".form-meta, .form-body, .form-upload").show();
							$("#PageLayoutId, #PageIsVisible, #PageIsCategory").closest("div.input").show();
							break;

						case "<?= Page::TYPE_WRAPPER ?>":
							$("#PageIsVisible, #PageIsActive, #PageIsCategory").closest("div.input").show();
							break;

						case "<?= Page::TYPE_LINK ?>":
							$("#PageUrl, #PageUrlTarget").closest("div.input").show();
							break;

						case "<?= Page::TYPE_MODULE ?>":
							$("#PageLayoutId").closest("div.input").show();
							$(".nav-tabs li:eq(1)").show();
							$(".form-meta, .form-body").show();
							break;
					}
				}).change();

				// Page Select
				$('.page-select').change(function () {
					var page = $(this).val();
					if (page === '') {
						$(this).prev().val('');
					} else {
						$(this).prev().val('page:' + page);
					}
				});

				// Sort content
				$(function () {
					$('.content-template-list').sortable({
						'axis': 'y',
						'delay': '50px',
						'handle': '.content-template-name'
					});
				});

				// Add more templates
				$('.content-append select').change(function () {
					var val = $(this).val();
					if (val !== '') {
						var div = $(this).closest('.content');
						var rel = div.attr('rel');
						var list = div.find('.content-template-list');
						var next = $('.content-template-new').length + 1;
						var locale = div.attr('class').match(/polyglot-([a-zA-Z][a-zA-Z])\b/)[1];
						$.get(
							'/<?= Configure::read('Config.language') ?>/pages/template/' + val + '/' + rel + '/' + locale + '/n' + next,
							{},
							function (response) {
								list.append(response);
								initializeRichTextEditors();
							}
						);
						$(this).val('');
					}
				});
			});


			/* File upload functions */
			<?php echo $this->Html->script([ 'jquery/jquery.iframe-transport', 'jquery/jquery.fileupload' ], false) ?>
			$(function () {
				$('input.new-upload:not(.activated)').each(function (i, upload) {
					$(upload).addClass('activated').fileupload({
						dataType: 'html',
						dropZone: $(this).closest('.file-drop-zone'),
						done: function (e, data) {
							$(this).closest('.file-list').children('ul').prepend(data.result);

							if (!$(this).is('[multiple]')) {
								$(this).remove();
							}
						}
					});
				});

				$('.file-list ul').sortable({
					axis: 'y',
					handle: '.file-preview',
					placeholder: "ui-state-highlight"
				});
			});

			/* Resubmit file */
			$('form').on('click', '.file-change', function () {
				$(this).closest('li').find('input[type=file]').toggle();
				return false;
			});

			/* Delete file */
			$('form').on('click', '.file-delete', function () {
				var li = $(this).closest('li');
				var img = $('.file-preview > img', li);
				var input = $('input.delete', li);

				var marked = input.val();
				if (marked == 0) {
					input.val(1);
					$(this).text("<?= __('undelete') ?>");

					var mask = $('<div class="file-mask">').css({
						width: img.width(),
						height: img.height()
					});
					img.after(mask);

				} else {
					input.val(0);
					$(this).text("<?= __('delete') ?>");

					img.next('.file-mask').remove();
				}

				return false;
			});

			/* Some tabs */
			$('.nav-tabs a').click(function () {
				$('.tab').hide();
				$($(this).attr('href')).show();
				$(this).closest('li').addClass('active').siblings().removeClass('active');
				$('.add-field').toggle($('#FieldTab').is(':visible'));
				return false;
			});
			$('.nav-tabs:not(.polyglot-tabs) a:first').click();

		</script>
	</div>
</div>
