<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.console.libs.templates.views
 * @since         CakePHP(tm) v 1.2.0.5234
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

Timer::start('scaffold');

{

	$model = ClassRegistry::init($modelClass);
	$modelPlugin = strtolower($model->plugin);

	$this->viewVars['model'] = $model;
	$this->viewVars['modelPlugin'] = $modelPlugin;

	$schema = $model->schema(true);
	foreach ($schema as $field => $params) {
		if (substr($params['type'], 0, 4) == 'enum') {
			$schema[$field]['type'] = 'enum';
		}
	}

	# Set default ordering visible
	if (!empty($model->order) && empty($this->request->params['paging'][$model->alias]['options']['order'])) {
		$this->request->params['paging'][$model->alias]['options']['order'] = $model->order;
	}

	$showSidebar = !empty($category_tree) || !empty($tree) && $treeview;

	$classMapping = [
		'float'       => 'int',
		'integer'     => 'int',
		'biginteger'  => 'int',
		'decimal'     => 'int',
		'string'      => 'char',
		'enum'        => 'char',
		'text'        => 'text',
		'tinytext'    => 'text',
		'boolean'     => 'bool',
		'datetime'    => 'time',
		'date'        => 'date',
		'association' => 'img'
	];

	Timer::start('field prepration');
	{

		$showFields = [];
		if (isset($administrator['Administrator']['customization'][$modelClass])) {
			foreach ($administrator['Administrator']['customization'][$modelClass] as $field => $params) {
				if (!empty($params['show']) && !in_array($field, $model->invisible) && ($model->schema($field) || isset($model->hasOne[$field]))) {
					$column['ordering'] = isset($params['ordering']) ? $params['ordering'] : PHP_INT_MAX;
					$column['field'] = $field;
					$column['fieldname'] = preg_replace('~([a-zA-Z0-9])([A-Z])~', '$1 $2', $field);
					$column['label'] = Inflector::humanize($field);
					$column['type'] = $model->schema($field) ? res(explode('(', $model->_schema[$field]['type'])) : 'association';
					switch (true) {
						case $column['field'] == $model->displayField:
							$column['class'] = 'title';
							break;

						case substr($column['field'], -3) == '_id':
							$column['class'] = 'char';
							break;

						case $column['field'] == 'approval_status':
							$column['class'] = 'state';
							break;

						default:
							$column['class'] = isset($classMapping[$column['type']]) ? $classMapping[$column['type']] : null;
					}
					$showFields[] = $column;
				}
			}
		}

		if (empty($showFields)) {
			$showFields[] = [
				'ordering'  => 0,
				'field'     => $model->displayField,
				'fieldname' => preg_replace('~([a-zA-Z0-9])([A-Z])~', '$1 $2', $model->displayField),
				'label'     => Inflector::humanize($model->displayField),
				'type'      => 'string',
				'class'     => 'title'
			];
		}

		$showFields = Set::sort($showFields, '{n}.ordering', ASC);

	}
	Timer::end('field prepration');
	?>

	<?= $this->Html->script('dragtable', false, [ 'inline' => false ]) ?>

	<div class="row">

		<?php if ($showSidebar) { ?>
			<?= $this->element('index/side_bar') ?>
		<?php } ?>

		<div class="col-md-<?= $showSidebar ? '8' : '12' ?> col-lg-<?= $showSidebar ? '10' : '12' ?>">
			<div class="main-content<?= $showSidebar ? ' with-sidebar' : null ?>">
				<div class="header">
					<?php
					Timer::start('Buttons');
					{
						# Custom index restrictions
						$customIndexRestrictionButton = null;
						$restrictions = $model->customIndexRestrictions();
						if (!empty($restrictions)) {
							$options = [];

							foreach ($restrictions as $name => $restriction) {
								$options[$name] = urlencode($name);
							}

							$options = array_filter($options);

							ob_start(); ?>

							<div class="btn-group">
								<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<?= $customIndexRestriction ?> <span class="caret"></span>
								</button>
								<ul class="dropdown-menu" id="CustomIndexRestriction">
									<?php foreach ($options as $option => $link) { ?>
										<li><a href="<?= $link ?>"><?= $option ?></a></li>
									<?php } ?>
								</ul>
							</div>

							<?php $customIndexRestrictionButton = ob_get_clean();
						}

						# Other actions
						echo $this->Format->actions(array_merge(
							[

								# Add new
								$model->isAddable()
									? [ 'plus', __('Add new'), [ P => $modelPlugin, C => $controller, A => 'add', 'show' => $customIndexRestriction ], [ 'class' => 'btn btn-success' ] ]
									: [],

								# Edit module
								$model->isModule && !empty($isSuperadmin) && $model->isModuleEditable()
									? [ 'magic', __('Edit module'), [ C => 'modules', A => 'edit', $model->moduleId ], [ 'class' => 'btn btn-default' ] ]
									: [],

								# Edit
								$model->isModule && $model->hasDetails
									? [ 'file-text-o', __('Edit template'), [ C => 'pages', A => 'module', $modelClass ] ]
									: [],

								# Categories
								$model->schema('category_id')
									? [ 'folder-open', __('View categories'), [ C => $controller, A => 'categories' ] ]
									: [],

								# Comments
								$model->isModule && $model->hasComments
									? [ 'align-left', __('View comments'), [ P => $modelPlugin, C => $controller, A => 'comments' ] ]
									: [],

								# Customize view
								[ 'columns', __('Customize view'), '#CustomizeTableModal', [ 'class' => 'btn btn-default', 'role' => 'button', 'data-toggle' => 'modal' ] ],

								# Treesort
								!empty($treeview)
									? [ 'code-fork', __('Sort'), '#SortTreeModal', [ 'class' => 'btn btn-default', 'role' => 'button', 'data-toggle' => 'modal' ] ]
									: [] ],

							# Additional actions from controller
							$_actions,

							# Export
							[ $this->element('index/export_buttons', compact('model', 'records')) ],

							# Filter
							[ $this->Format->filter() ],

							# Quick filter
							[ '<input type="text" id="QuickFilter" value="' . (!empty($this->request->data[$model->alias]['_keyword']) ? $this->request->data[$model->alias]['_keyword'] : null) . '" />' ],

							# Custom index restrictions
							[ $customIndexRestrictionButton ]
						));

						# For tree view
						if (!empty($treeview)) {
							echo $this->element('index/sort_tree');
						}

						# Customize view
						echo $this->element('index/customize_table');

					}
					Timer::end('Buttons');

					# Filter
					Timer::start('Filter');
					{

						$filter = [ '_keyword' ];
						$keywords = false;
						$ignoreFilter = [ 'id', 'ordering', 'modified', 'modified_by', 'created', 'created_by' ];
						foreach ($schema as $field => $params)
							if ($model->table == 'pages') {
								if (!in_array($params['type'], [ 'string', 'text' ]) && !in_array($field, array_merge($ignoreFilter, $model->invisible))) {
									$filter[] = $field;
								}
							} else {
								if (!in_array($params['type'], [ 'string', 'text' ]) && !in_array($field, array_merge($ignoreFilter, $model->invisible)) || substr($field, -4) == '_set') {
									$filter[] = $field;
								}
							}
						echo $this->Format->filter($filter);

					}
					Timer::end('Filter');
					?>
				</div>

				<div class="clear"></div>

				<div class="cms_<?= str_replace(' ', '_', $plural) ?> index clearfix">
					<?php if (!empty($records)) { ?>
						<?php

						# Count records for each category
						if (!empty($model->Category)) {
							$categoriesIds = Set::extract('/' . $modelClass . '/category_id', $records);
							foreach (array_unique($categoriesIds) as $categoryId) {
								$modelCategoryRecords[$categoryId] = $model->find('count', [
									'conditions' => [
										$modelClass . '.category_id' => $categoryId
									]
								]);
							}
						}

						# Count max existing records in database TODO -> count only active records
						$modelRecords = min(100000, $model->find('count', [
							'conditions' => []
						]));

						# Set range for select box
						$options = range(1, $modelRecords);
						$options = array_combine($options, $options);
						?>

						<div class="table-options clearfix">
							<?= $this->element('index/multiselect', [ 'model' => $model ]) ?>
							<?= $this->element('index/paginator') ?>
						</div>

						<form id='emailSendForm' method="post" action="">
							<table cellpadding="0" cellspacing="0" class="draggable sortable main-table-index" id="<?= $model->alias ?>Index">
								<thead>
									<tr>
										<th class="box" width="43" style="width:43px;">&nbsp;</th>

										<?php foreach ($showFields as $field) { ?>
											<th id="th-<?= $field['field'] ?>" class="<?= $field['class'] ?>">
												<?=
												!in_array($field['class'], [ 'img' ])
													? !empty($this->request->params['all'])
													? str_replace('/index/all/', '/all/', $this->Paginator->sort($field['fieldname'], $field['label'], [ 'model' => $modelClass ]))
													: $this->Paginator->sort($field['fieldname'], $field['label'], [ 'model' => $modelClass ])
													: $field['fieldname']
												?>
											</th>
										<?php } ?>

										<th class="actions"><?= __('Actions') ?></th>
									</tr>
								</thead>

								<tbody>
									<?php Timer::start('output');
									{ ?>
										<?php foreach ($records as $i => $record) { ?>
										<?php

										# Default values
										$params = [
											'data-id' => $record[$model->alias][$model->primaryKey],
											'class'   => []
										];

										# Custom class
										if ($customClass = $model->getIndexRowClass($record)) {
											$params['class'][] = $customClass;
										}

										# Set range for select box
										if (!empty($record[$modelClass]['category_id'])) {
											$options = range(1, $modelCategoryRecords[$record[$modelClass]['category_id']]);
											$options = array_combine($options, $options);
										}

										# For tree view
										if (!empty($treeview)) {

											# Child
											if (!empty($record[$model->alias]['parent_id'])) {
												$params['data-tt-parent-id'] = $record[$model->alias]['parent_id'];
												$params['classes'][] = 'tree-subitem';

												# Parent
											} else {
												$params['classes'][] = 'tree-parent';
											}

											# Tree view ID
											$params['data-tt-id'] = $record[$model->alias][$model->primaryKey];
										}
										?>
										<tr <?= $this->Html->attributes($params) ?>>

											<td class="box">
												<input type="checkbox" id="PageBox-<?= $record[$model->alias][$model->primaryKey] ?>" value="<?= $record[$model->alias][$model->primaryKey] ?>" name="data[Page][box-<?= $record[$modelClass][$model->primaryKey] ?>]" />
											</td>

											<?php
											$filedsTypes = [];
											foreach ($showFields as $i => $field) {
												$filedsTypes[] = $field['field'];
												$class = '';
												$value = !empty($record[$modelClass][$field['field']]) ? strip_tags($record[$modelClass][$field['field']]) : '';
												switch ($field['field']) {
													default:

														# Display field
														if ($field['class'] == 'title') {

															# Get the proper action
															$mainAction = $model->isEditable($record[$modelClass][$model->primaryKey]) && !$model->preferView($record[$modelClass][$model->primaryKey])
																? 'edit'
																: 'view';

															$value = $this->Html->link($record[$modelClass][$field['field']], [ P => $modelPlugin, C => $controller, A => $mainAction, $record[$modelClass][$model->primaryKey] ], [/*'title' => __('Unique id') . ': ' . $record[$model->alias]['id']*/ ]);

															# Full text fields
														} else if ($field['class'] == 'text') {
															$value = $this->Text->truncate(strip_tags($value), 150, [ 'exact' => false ]);

															# Color
														} else if (substr($field['field'], -5) === 'color') {
															$value = '<span class="font-monospace">' . $value . '</span>&nbsp;<span class="color-box" style="background-color: ' . $value . '">&nbsp;&nbsp;&nbsp;&nbsp;</span>';

															# Ordering
														} else if ($field['field'] == 'ordering') {
															$field['class'] = 'int ordering';
															$value = $this->Html->image('ico/loader_small.gif') . $this->Form->input('ordering', [
																	'format'         => [ 'input' ],
																	'class'          => 'moduleOrdering',
																	'options'        => $options,
																	'selected'       => $value,
																	'data-module'    => $modelClass,
																	'data-record-id' => $record[$modelClass][$model->primaryKey] ]);

															# Approval status
														} else if ($field['field'] == 'approval_status') {
															switch ($value) {
																case 'Pending':
																	$icon = 'exclamation';
																	$link = true;
																	break;
																case 'Rejected':
																	$icon = 'ban';
																	$link = false;
																	break;
																case 'Accepted':
																	$icon = 'check';
																	$link = false;
																	break;
																default:
																	$icon = 'history';
																	$link = false;
																	break;
															}
															$icon = $this->Html->tag('i', '', [ 'class' => "fa fa-{$icon}" ]);
															$value = $this->Html->tag('span', $icon . ' ' . $value, [ 'class' => 'approval approval-' . strtolower($value) ]);
															if ($link)
																$value = $this->Html->link($value, [ A => 'edit', $record[$model->alias]['id'] ], [ 'escape' => false, 'title' => __('Click to edit') ]);

															# URLs
														} else if ($field['field'] == 'url') {
															$value = $this->Html->link(preg_replace('~^[^:]*://~', '', $value), $value, [ 'target' => '_blank' ]);

															# Associative fields
														} else if (($id = substr($field['field'], -3) == '_id') || (($var = Inflector::variable(Inflector::pluralize($field['field']))) && isset($$var))) {
															if ($id) {
																$var = Inflector::variable(Inflector::pluralize(substr($field['field'], 0, -3)));
															}
															$var = $$var;
															$value = isset($var[$value]) ? $var[$value] : null;

															# Uploads
														} else if (isset($record[$field['field']])) {
															if (!empty($record[$field['field']]['filename'])) {
																$value = $this->Manicure->match($record[$field['field']], 74, 36, $field['field']);
															} else {
																$value = $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]);
															}

															# Other fields
														} else {
															$class = $classMapping[$schema[$field['field']]['type']];
															switch ($model->_schema[$field['field']]['type']) {

																case 'boolean':
																	$value = !in_array($field['field'], $model->locked)
																		? $this->Format->toggle($controller, $record[$modelClass], $field['field'])
																		: $this->Format->bool($value);
																	break;

																case 'date':
																	$value = $this->Format->time($value);
																	break;

																case 'datetime':
																	$value = $this->Format->time($value, true);
																	break;
															}
														}
												}
												$class = !empty($field['class']) ? ' class="' . $field['class'] . '"' : '';

												# Handle enum providers
												if ($field['type'] == 'enum') {
													$enumProvider = 'get' . Inflector::classify($field['field']) . 'Enum';
													if (method_exists($model, $enumProvider)) {
														$enumOptions = $model->$enumProvider();
														if (!empty($enumOptions[$value])) {
															$value = $enumOptions[$value];
														}
													}
												}

												# Additional decorations of the cell
												$value = $model->decorateCellValue($value, $field['field'], $record);

												echo "<td{$class}>{$value}</td>\n";
											}
											?>
											<td class="actions">
												<?php
												Timer::startLoop('Actions');
												{
													echo $this->Format->actions([

														$model->getIndexActions($record),

														# View
														$model->alias == 'Page'
															? [ 'eye', '', $this->Format->pageLink($record[$modelClass][$model->primaryKey]), [ 'class' => 'btn btn-default btn-sm btn-icon-only', 'target' => '_blank' ] ]
															: [ 'eye', '', [ P => $modelPlugin, C => $controller, A => 'view', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-default btn-sm btn-icon-only' ] ],

														# Edit
														$model->isEditable($record[$modelClass][$model->primaryKey])
															? [ 'pencil', '', [ P => $modelPlugin, C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-default btn-sm btn-icon-only' ] ]
															: [],

														# Delete
														$model->isDeletable($record[$modelClass][$model->primaryKey])
															? [ 'trash-o', '', [ P => $modelPlugin, C => $controller, A => 'delete', $record[$modelClass][$model->primaryKey] ], [ 'class' => 'btn btn-danger btn-sm btn-icon-only', 'confirm' => __('Are you sure you want to delete') . ":\n" . $record[$modelClass][$model->displayField] . ' ?' ] ]
															: []
													]);
												}
												Timer::endLoop('Actions');
												?>
											</td>
										</tr>
									<?php } ?>
									<?php }
									Timer::end('output') ?>
								</tbody>
							</table>

							<p id="EmptyQuickFilter" class="info warn">
								<?= __('No records match the quick filter, please press [ENTER] button on your keyboard to search the whole database.') ?>
							</p>
						</form>

						<div class="table-options clearfix">
							<?= $this->element('index/multiselect', [ 'model' => $model ]) ?>
							<?= $this->element('index/paginator', [ 'bottom' => true ]) ?>
						</div>

						<script type="text/javascript">
							<?php if(in_array('ordering', $filedsTypes)) { ?>
							$(document).ready(function () {

								// Get the current page
								var currentPage = <?= !empty($this->request->params['named']['page']) ? ($this->request->params['named']['page'] - 1) * $model->paginate : 0 ?>;

								// Sorting table rows
								$('#emailSendForm > table > tbody').sortable({
									cancel: ".char, .ordering",
									axis: 'y',
									handle: '.title a, td.actions',
									placeholder: 'ui-state-highlight',
									stop: function (event, ui) {
										reorder(ui.item, ui.item.prevAll().length + 1 + currentPage);
									},
									start: function (event, ui) {
										ui.placeholder.css('height', ui.item.height());
									}
								});

								// Regulate reordering
								$('.select .moduleOrdering').change(function () {
									$this = $(this);
									var recordData = [];

									// No recursion
									if (!($this).css('opacity')) {
										return;
									}

									// Send request
									reorder($this.closest("tr"), $this.val());
								});
							});

							function reorder(row, position) {

								// Hide while working
								$('select.moduleOrdering').css('opacity', 0);
								row.find('td.ordering img').show();

								// Send request
								$.ajax({
									url: "<?= '/' . $locale . '/' . $model->useTable ?>/ajax_reorder/",
									dataType: "json",
									type: "POST",
									data: {
										"id": row.data("id"),
										"ordering": position
									},
									success: function (data) {

										// Update with new values
										$('select.moduleOrdering').each(function () {
											$(this).val(data[$(this).data("record-id")]);
										});

										// Show them
										$('select.moduleOrdering').css('opacity', 1);
										$('select.moduleOrdering').closest('td').find('img').hide();
									},
									error: function () {
									}
								});
							}
							<?php } ?>

							// Ajax toggle
							$('td.bool a[class^=switch_]').click(function (event) {

								// Show loader
								$(this).html($('<img src="/img/ico/loader_small.gif" />'));

								// Execute over AJAX
								$.get(
									$(this).attr('href'),
									function (response) {

										// Get the response
										if (response == 'Error!') return;
										if (typeof(response) == 'string') {
											eval('response = ' + response + ';');
										}

										// Switch values
										var on = function () {
											return $('<i class="<?= ON_FA_VALUE ?>">');
										};
										var off = function () {
											return $('<i class="<?= OFF_FA_VALUE ?>">');
										};

										// For single values
										if (response.single && response.value) {
											$('td.bool a[class^=switch_]').html(off);
										}

										// Show the new value
										$('td.bool a.switch_' + response.field + '_' + response.id).html(response.value ? on : off);
									}
								);

								event.preventDefault();
								return false;
							});

							// Quick filter
							$("#QuickFilter").focus().select().bind('input propertychange', function () {

								// When value of the input is not blank
								if ($(this).val() != "") {
									$("div.index table tbody > tr").hide();
									$("div.index table tbody td:contains-ci('" + $(this).val() + "')").parent("tr").show();

									// Handle empty results
									if (!$("div.index table tbody > tr:visible").size()) {
										$('#EmptyQuickFilter').show();
									} else {
										$('#EmptyQuickFilter').hide();
									}

									// When there is no input or clean again, show everything back
								} else {
									$("div.index table tbody > tr").show();
									$('#EmptyQuickFilter').hide();
								}
							});

							// Case insensitive contains
							$.extend($.expr[":"], {
								"contains-ci": function (elem, i, match, array) {
									return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
								}
							});

							<?php if($treeview) { ?>
							$(function () {
								$("#<?= $model->alias ?>Index").treetable({
									column: 1,
									expandable: <?= $model->treetableExpandable() ? 'true' : 'false' ?>,
									initialState: '<?= $model->alias == 'Page' ? 'expanded' : 'collapsed' ?>',
									stringExpand: '<?= __('Expand') ?>',
									stringCollapse: '<?= __('Collapse') ?>'
								});
							});
							<?php } ?>
						</script>

					<?php } else { ?>
						<div class="empty well">
							<?php if (empty($this->request->params['filter'])) { ?>
								<?= __('There are no records for this module in the database.') ?>
								<?php if ($model->isAddable() && in_array(Inflector::tableize($this->request->params[C]), Set::extract('/Module/use_table', Stash::read('modules')))) { ?>
									<br /><br />
									<?= $this->Html->link(__('Click here to populate with random records.'), [ P => $modelPlugin, C => $controller, A => 'populate', 14 ]) ?>
								<?php } ?>
							<?php } else { ?>
								<?= __('No records have been found, please refine your search.') ?>
							<?php } ?>
						</div>
					<?php } ?>

				</div>
			</div>

		</div>
	</div>



	<script type="text/javascript">
		$(function () {

			// Search from quick filter enter
			$("#QuickFilter").keyup(function (event) {
				if (event.keyCode == 13 && $(this).val() != '') {
					$('#<?= $model->alias ?>Keyword').val($(this).val()).closest('form').submit();
				}
			});

			// Custom index restriction
			$('#CustomIndexRestriction a').click(function (e) {
				var show = $(this).attr('href');
				location = "<?= Router::url([ C => $this->request->params['controller'], A => 'index', 'show' => '_____' ]) ?>".replace(/show:_____/, 'show:' + (show ? show : '*'));

				e.preventDefault();
				return false;
			});
		})
	</script>

<?php }

Timer::end('scaffold') ?>
