<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright        Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link             http://cakephp.org CakePHP(tm) Project
 * @package          cake
 * @subpackage       cake.cake.console.libs.templates.views
 * @since            CakePHP(tm) v 1.2.0.5234
 * @license          MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
Timer::start('scaffold');
{

	$model = ClassRegistry::init($modelClass);
	$modelPlugin = strtolower($model->plugin);

	$this->viewVars['model'] = $model;
	$this->viewVars['modelPlugin'] = $modelPlugin;

	$schema = $model->schema(true);
	foreach ($schema as $field => $params)
		if (substr($params['type'], 0, 4) == 'enum') {
			$schema[$field]['type'] = 'enum';
		}
	$skip = [
		'id',
		'category_id',
		'published',
		'release_date',
		'ordering',
		'slug',

		'is_active',
		'is_deleted',
		'is_translated',

		'modified',
		'modified_by',
		'created',
		'created_by',

		'seo_metatags',
		'seo_generated_metatags'
	];

	$languages = Configure::read('Config.Languages');
	?>

	<div class="col-md-3">
		<div class="view-bar">
			<?php

			# ID
			if (isset($record[$modelClass]['id'])) {
				echo '<div class="header">';
				echo '<b class="pull-right">' . $record[$modelClass]['id'] . '</b>';
				echo '<b>' . __('Unique ID') . ':</b>';
				echo '</div>';
			}

			# Deleted
			if (!empty($record[$modelClass]['is_deleted'])) {
				echo '<div class="status status-error">' . __('This record has been deleted') . '</div>';
			}

			# Display image
			if (!empty($model->displayImage)) {
				if (!empty($record[$model->displayImage]['filename'])) {
					echo '<div class="display-image">' . $this->Format->image($record[$model->displayImage], null, null, [ 'class' => 'display-image' ]) . '</div>';
				} else {
					echo '<div class="empty well">' . __('No ' . preg_replace('~(?<=.)([A-Z])~', ' $1', $model->displayImage)) . '</div>';
				}
			}

			# Active
			if (empty($record[$modelClass]['is_deleted']) && isset($record[$modelClass]['is_active'])) {
				echo $record[$modelClass]['is_active']
					? '' //'<div class="status status-success">' . __('This record is active') . '</div>'
					: '<div class="status status-warning">' . __('This record is inactive') . '</div>';
			}

			# Ordering
			if (isset($record[$modelClass]['ordering'])) {
				echo '<div class="view-bar-section">';
				echo '<span class="pull-right">' . $record[$modelClass]['ordering'] . '</span>';
				echo '<b>' . __('Ordering') . ':</b>';
				echo '</div>';
			}

			# Category
			if (isset($record[$modelClass]['category_id']) && !empty($record['Category'])) {
				$spans = [];
				foreach ($languages as $locale => $language) {
					//$spans[] = $this->Html->tag('span', $record['Category']['title__'][$locale], array('class' => 'list lang lang-' . $locale, 'style' => 'display:' . ($locale == Configure::read('Config.language') ? 'inline' : 'none')));
				}
				$spans = [ $record['Category']['title'] ];
				$link = $this->Html->link(implode($spans), [ C => $controller, A => 'categories', 'view', $record[$modelClass]['category_id'] ], [ 'class' => 'right', 'title' => __('Show category details') ]);
				$value = $this->Html->tag('b', __('Category') . ':');
				echo $this->Html->tag('div', $link . $value);
			}

			# Release date
			$dates = [ 'release_date', 'published' ];
			foreach ($dates as $date)
				if (isset($record[$modelClass][$date])) {
					echo '<div class="view-bar-section">';
					echo '<span class="right">' . $this->Format->time($record[$modelClass][$date]) . '</span>';
					echo '<b>' . __('Release date') . ':</b>';
					echo '</div>';
					break;
				}

			# Languages
			if (sizeof($languages) > 1 && isset($record[$modelClass]['is_translated'])) {
				$count = 0;
				echo '<div class="view-bar-section">';
				foreach ($languages as $locale => $language) {
					if (!empty($record[$modelClass]['is_translated__'][$locale])) {
						$count++;

						$icon = !empty($language['Icon']['file'])
							? $this->Html->image($language['Icon']['file'])
							: $language['Language']['locale'];
						echo $this->Html->link($icon, 'javascript: void(0)', [ 'class' => 'flag pull-right' . ($locale == Configure::read('Config.language') ? ' flagged' : ''), 'title' => $language['Language']['title'], 'rel' => $locale ]);
					}
				}
				if (!$count) {
					echo '<span class="right no-languages" title="' . __("This {$singular} is not translated to any language") . '">' . __('no language') . '</span>';
				}
				echo '<b>' . __('Translated to') . ':</b>';
				echo '</div>';
			}

			echo '<div class="view-bar-uploads">';

			# Uploads
			foreach ([ 'hasOne', 'hasMany' ] as $type) {
				foreach ($model->$type as $association => $params)
					if ($params['className'] == 'Upload') {

						# Single upload
						if ($type == 'hasOne') {

							# Skip display image, it has already been shown
							if ($association == $model->displayImage)
								continue;

							# Always display as documents
							$documents = true;
							$record[$association] = [ $record[$association] ];

							# Multiple upload
						} else {

							# Check if should be displayed as documents
							$documents = false;
							foreach ($record[$association] as $i => $file) {
								if (!empty($file['filename']) && !in_array(strtolower(lastFromDot($file['filename'])), [ 'jpg', 'jpeg', 'png', 'gif' ])) {
									$documents = true;
									break;
								}
							}
						}

						# Output subtitle
						echo '<strong>' . preg_replace('~(?<=.)([A-Z])~', ' $1', $association) . '</strong>';

						# There are some uploads
						$empty = $type === 'hasMany' ? empty($record[$association]) : empty($record[$association][0]['filename']);
						if (!$empty) {
							foreach ($record[$association] as $i => $file)
								if (!empty($file['filename'])) {

									# Uploads contains documents
									if ($documents) {
										$fancybox = '';
										$extension = strtolower(lastFromDot($file['filename']));

										# Image
										if (in_array($extension, [ 'jpg', 'jpeg', 'gif', 'png', 'svg' ])) {
											$fancybox = 'fancybox ';
											$image = $this->Format->image($file, 80, null, false);

											# PDF
										} else if ($extension == 'pdf') {
											$image = $this->Format->image($file, 80, null, false);

											# Other documents
										} else {
											$mime = lastFromDot($file['filename']);
											if (!is_file(WWW_ROOT . "/img/mimetypes/{$mime}.png")) {
												$mime = 'default';
											}
											$image = $this->Html->image("mimetypes/{$mime}.png");
										}

										# Output
										echo $this->Html->link(
											$image . $this->Html->tag(
												'div',
												'<span>' . str_replace('_', ' ', $file['filename']) . '</span>' .
												'<em>' . $this->Format->filesize($file['filesize']) . '</em>'),
											$file['file'],
											[
												'class'  => $fancybox . 'view-bar-direct-link',
												'target' => '_blank' ]
										);
										echo '<div class="clear"></div>';

										# Uploads contains only Images
									} else {
										$class = !(($i - 1) % 3) ? ' middle' : (!($i % 3) ? ' clear-left' : '');
										echo $this->Format->image($file, 84, 55, [ 'class' => 'view-bar-gallery' . $class, 'rel' => $association ]);
									}
								}

							# No uploads
						} else {
							echo '<p class="empty-small">' . __('No ' . preg_replace('~(?<=.)([A-Z])~', ' $1', $association)) . '</p>';
						}
					}
			}

			echo '</div>';

			# More details
			echo $this->Html->link(__('show more'), '#moreDetails', 'more-details');
			echo '<div class="view-bar-more-details">';

			# Slug
			if ($model->isModule && $model->hasDetails) {
				echo '<div class="view-bar-section">';
				echo '<span class="pull-right">' . $record[$modelClass]['slug'] . '</span>';
				echo '<b>' . __('Unique slug') . ':</b>';
				echo '</div>';
			}

			# Created
			echo '<div class="view-bar-section">';
			echo '<b>' . __('Created') . ':</b>';
			echo '<span class="pull-right">' . $this->Format->time($record[$modelClass]['created']) . '</span>';

			if (isset($record[$modelClass]['created_by']) && isset($createdBies[$record[$modelClass]['created_by']])) {
				echo '<br /><span class="pull-right">' . __('by') . ' ' . $createdBies[$record[$modelClass]['created_by']] . '</span>';
			}
			echo '</div>';

			# Modified
			echo '<div class="view-bar-section">';
			echo '<b>' . __('Last modified') . ':</b>';
			echo '<span class="pull-right">' . $this->Format->time($record[$modelClass]['modified']) . '</span>';

			if (isset($record[$modelClass]['modified_by']) && isset($modifiedBies[$record[$modelClass]['modified_by']])) {
				echo '<br /><span class="pull-right">' . __('by') . ' ' . $modifiedBies[$record[$modelClass]['modified_by']] . '</span>';
			}
			echo '</div>';

			echo '</div>';
			?>
		</div>
	</div>

	<div class="col-md-9">
		<div class="main-content">
			<div class="header">

				<div class="btn-group pull-right" data-toggle="buttons" style="margin-right:5px">
					<label class="btn btn-default active" id="overview">
						<input type="radio" name="panel" checked="checked" onchange="toggleHistory('overview')" />
						<?= __('Overview') ?>
					</label>
					<label class="btn btn-default" id="history">
						<input type="radio" name="panel" onchange="toggleHistory('history')" />
						<?= __('History') ?>
					</label>
				</div>

				<?= $this->element('view/actions', [ 'controller' => $controller, 'model' => $model, 'record' => $record ]) ?>
			</div>
			<div class="clear"></div>

			<?php $underscoredPlural = str_replace(' ', '_', $plural); ?>
			<div class="cms_<?= $underscoredPlural ?> view">
				<?php if ($this->elementExists($underscoredPlural . '/view/overview')) { ?>
					<?= $this->element($underscoredPlural . '/view/overview', compact('schema', 'list', 'skip')) ?>
				<?php } else { ?>
					<?= $this->element('scaffolds/view/overview', compact('schema', 'list', 'skip')) ?>
				<?php } ?>
				<div class="view-list view-history<?= empty($logHistory) ? ' view-history-empty' : null ?>" style="display:none">
					<?php if (empty($logHistory)) { ?>
						<p class="empty well"><?= __('No history for this item.') ?></p>
					<?php } else { ?>
						<button id="expandBtn" type="button" class="btn btn-default pull-right" onclick="expandAllHistory()"><?php echo __('Expand all'); ?></button>
						<?php
						foreach ($logHistory as $log) {
							echo $this->Format->showLog($log, 'view');
						}
						?>
					<?php } ?>
					<div style="clear:both"></div>
				</div>
				</dl>
			</div>
		</div>
	</div>

	<script type="text/javascript">

		/* Select translation */
		$('.view-bar-section a.flag').click(function () {
			$('.lang').hide();
			$('.lang.lang-' + $(this).attr('rel')).show();
			$('.view-bar-section a.flag').removeClass('flagged');
			$(this).addClass('flagged');
		});

		/* Toggle more details */
		$('a.more-details').click(function () {
			$('.view-bar-more-details').fadeToggle();
			return false;
		});


		function toggleHistory(param) {
			$("div.view-list").hide();
			$("div.view-" + param).show();
		}


		function showDetails(id) {
			if ($(".log-history-item#history-item-" + id).is(":visible")) {
				$(".log-history-item#history-item-" + id).hide();
			} else {
				$(".log-history-item#history-item-" + id).fadeToggle('fast');

			}
		}

		function expandAllHistory() {
			var btnText = $("#expandBtn").text();

			if (btnText == '<?php echo __("Expand all");?>') {
				$(".log-history-item").show('fast');
				$("#expandBtn").text('<?php echo __("Collapse all");?>');
			} else {
				$(".log-history-item").hide('fast');
				$("#expandBtn").text('<?php echo __("Expand all");?>');
			}

		}

		var url = window.location.hash.substring(1).split('-');
		if (url[0] == 'history') {
			$('#history').trigger('click');
			showDetails(url[1]);
			$("html,body").animate(
				{
					scrollTop: $('.log-item-' + url[1]).offset().top
				},
				'slow');
		}

	</script>
<?php }
Timer::end('scaffold') ?>
