<?php

use Intellex\Generator\Basic\BooleanGenerator;
use Intellex\Generator\Text\SentenceGenerator;

$uploads = Theme::getListOfUploads();

?>
<div class="layouts index form theme-settings">

	<?= $this->Form->create('Theme', [ 'type' => 'file', 'class' => 'tabbed clearfix' ]) ?>

	<div class="col-sm-12">

		<div class="row">
			<div class="col-md-6">
				<?= $this->Form->getField('primary_color', [ 'type' => 'string' ], [ 'adjust' => true ]) ?>
			</div>
			<div class="col-md-6">
				<?= $this->Form->getField('secondary_color', [ 'type' => 'string' ], [ 'adjust' => true ]) ?>
			</div>
		</div>

		<div class="row">
			<?php foreach ($uploads as $upload => $info) { ?>
				<div class="col-md-<?= 12 / sizeof($uploads) ?>">
					<?= $this->element('theme/upload-item', array_merge([ 'name' => $upload, 'preview' => $this->request->data['Theme']['Uploads'][$upload] ], $info)) ?>
				</div>
			<?php } ?>
		</div>

		<hr />

		<div class="index">
			<table cellspacing="0" cellpadding="0" class="main-table-index theme-table">
				<thead>
				<tr>
					<th data-theme-preview-background class="box">&nbsp;</th>
					<th data-theme-preview-background class="title" id="th-image">
						<a href="javascript:void(0)"><?= __('Image') ?></a>
					</th>
					<th data-theme-preview-background class="title" id="th-name">
						<a href="javascript:void(0)"><?= __('Name') ?></a>
					</th>
					<th data-theme-preview-background class="char" id="th-author">
						<a href="javascript:void(0)"><?= __('Description') ?></a>
					</th>
					<th data-theme-preview-background class="bool" id="th-is_active">
						<a href="javascript:void(0)"><?= __('Is active') ?></a>
					</th>
					<th data-theme-preview-background class="bool" id="th-is_featured">
						<a href="javascript:void(0)"><?= __('Is featured') ?></a>
					</th>
					<th data-theme-preview-background class="actions"><?= __('Actions') ?></th>
				</tr>
				</thead>
				<tbody>
				<?php for ($i = 0; $i < 3; $i++) { ?>
					<tr class="odd">
						<td class="box">
							<input type="checkbox" />
						</td>
						<td class="image">
							<?php $image = (new \Intellex\Generator\Basic\ImageGenerator(Configure::read('Backend.pixabay_api_key'), 960))->generateValue() ?>
							<a href="<?= $image ?>" class="showup" rel="theme">
								<img style="display: block; width: 74px; height: 36px;" src="<?= $image ?>" />
							</a>
						</td>
						<td class="title">
							<a data-theme-preview-color href="javascript:void(0)">
								<?= (new SentenceGenerator())->generateValue() ?>
							</a>
						</td>
						<td class="char">
							<?= (new SentenceGenerator())->generateValue() ?>
						</td>
						<td class="bool">
							<?php $val = (new BooleanGenerator(80))->generateValue() ?>
							<a href="javascript:void(0)"><i <?= $val ? 'data-theme-preview-color ' : null ?> class="fa fa-<?= $val ? 'check' : 'times' ?>"></i></a>
						</td>
						<td class="bool">
							<?php $val = (new BooleanGenerator(50))->generateValue() ?>
							<a href="javascript:void(0)"><i <?= $val ? 'data-theme-preview-color ' : null ?> class="fa fa-<?= $val ? 'check' : 'times' ?>"></i></a>
						</td>
						<td class="actions">
							<div class="actions">
								<ul class="actions narrow-actions">
									<li>
										<a class="btn btn-sm btn-icon-only" href="javascript:void(0)"><i class="fa fa-fw fa-eye button"></i></a>
									</li>
									<li>
										<a class="btn btn-sm btn-icon-only" href="javascript:void(0)"><i class="fa fa-fw fa-pencil button"></i></a>
									</li>
									<li>
										<a class="btn btn-sm btn-icon-only btn-danger" href="javascript:void(0)"><i class="fa fa-fw fa-trash-o button"></i></a>
									</li>
								</ul>
							</div>
							<div class="clear"></div>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>

			<hr />

			<div class="theme-validator" data-visibility-toggle-controller="colors">
				<div data-visibility-toggle="colors:valid">
					<?= $this->Form->close(__('Update theme'), false, 'paint-brush') ?>
				</div>
				<p class="well error-box" data-visibility-toggle="colors:invalid" style="display: none">
					<b><?= __('Error') ?>:</b>
					<?= __('Theme cannot be saved as some of colors are not in a proper format.') ?>
				</p>
			</div>
		</div>
	</div>

	<script>
		postExecute(function () {

			/**
			 * The static class that handles the theme form.
			 */
			window.ThemeSupervisor = {

				/** @var {object} The list of color inputs. */
				input: {
					primary: $('#ThemePrimaryColor'),
					secondary: $('#ThemeSecondaryColor')
				},

				/** @var {object} The list of all elements that should be refresh when the color is changed. */
				output: {
					'[data-theme-preview-background], .theme-settings .btn-primary': {
						'background-color': '{{primary}}',
						'border-color': '{{secondary}}'
					},
					'[data-theme-preview-color]': {
						'color': '{{primary}}'
					}
				},

				/** @var {object} The jQuery element that holds button and error message elements. */
				validator: $('.theme-validator'),

				/**
				 * Initialize the theme form.
				 *
				 * @return {ThemeSupervisor} The reference to the supervisor.
				 */
				init: function () {

					// Primary color
					this.input.primary.change(function () {
						ThemeSupervisor.refresh(true);
					});

					// Secondary color
					this.input.secondary.change(function () {
						ThemeSupervisor.refresh(false);
					});

					// Initial refresh
					this.refresh(false);

					return this;
				},

				/**
				 * Convert the RRGGBB to proper CSS valid color.
				 *
				 * @param {string} color The initial color, in format RRGGBB.
				 *
				 * @return {string} The CSS valid color value.
				 * @throws Error If the input color cannot be parsed.
				 */
				color: function (color) {
					var hex = color.replace(/[^a-fA-F0-9]/, '');
					if (hex.match(/^([a-fA-F0-9]{3}){2}$/)) {
						return '#' + hex;
					}

					throw 'Unable to parse `' + color + '` to color.';
				},

				/**
				 * Refresh the status of the form, based on the selected values.
				 *
				 * @param {boolean} setSecondaryColor Set to true to update the secondary color form the value of the primary color.
				 */
				refresh: function (setSecondaryColor) {
//					try {

					// Assume that the form is valid, until proven otherwise
					this.validator.visibilityToggle('valid');

					// Get pimary color
					var primary = this.color(this.input.primary.val());

					// Set secondary color, if needed
					if (setSecondaryColor) {
						this.input.secondary.val('#' + ThemeSupervisor.darken(primary, 0.3));
						this.input.secondary.data('refreshCoolpick')();
					}
					var secondary = this.color(this.input.secondary.val());

					// Apply on all elements defined in output
					for (var selector in this.output) {
						var element = $(selector);

						// Iterate over each property
						for (var property in this.output[selector]) {
							if (this.output[selector].hasOwnProperty(property)) {

								// Set the values of primary and secondary colors
								var value = this.output[selector][property]
									.replace('{{primary}}', primary)
									.replace('{{secondary}}', secondary);

								// Apply the value
								element.css(property, value)
							}
						}
					}
//
//					} catch (error) {
//						this.validator.visibilityToggle('invalid');
//					}
				},

				/**
				 * Darken a supplied color by a given percentage.
				 *
				 * @param {string} inputColor The initial color, in format #RRGGBB
				 * @param {int}percentage The percentage to darken the input color.
				 *
				 * @returns {string} The darkened color, in format #RRGGBB.
				 */
				darken: function (inputColor, percentage) {
					var color = this.hexToRGB(inputColor.replace(/[^a-fA-F0-9]/, ''));
					var quote = 1 - percentage;

					return "" +
						this.decToHex(color.R * quote) +
						this.decToHex(color.G * quote) +
						this.decToHex(color.B * quote);
				},

				/**
				 * Convert color from hex value to RGB JSON.
				 *
				 * @param {string}   hexValue The initial color, in format #RRGGBB
				 *
				 * @returns {object} The JSON with the following properties: R, G and B.
				 */
				hexToRGB: function (hexValue) {
					return {
						R: parseInt(hexValue.substring(0, 2), 16),
						G: parseInt(hexValue.substring(2, 4), 16),
						B: parseInt(hexValue.substring(4, 6), 16)
					};
				},

				/**
				 * Convert decimal number to two-digit hex number
				 *
				 * @param {int}   decimalNumber The decimal number to convert.
				 *
				 * @returns {string} The hexadecimal representation of the number.
				 */
				decToHex: function (decimalNumber) {
					var hex = Math.round(decimalNumber).toString(16);

					// Make sure it is at least two digit wide
					if (hex.length < 2) {
						hex = "0" + hex;
					}

					return hex;
				}
			}.init();
		});

		// Upload
		postExecute(function () {
			$('input[data-theme-upload]').fileTransport({
				ss: this,

				success: function (event, file, token, meta) {
					var input = $(event.target);
					var id = input.attr('id');
					$('#' + id + 'Token').val(token);
					$('#' + id + 'Preview').attr('src', meta.thumbnail + '&w=180&h=180');
				},

				error: function (event, error, message) {
					alert(message);
				}
			});
		});
	</script>
</div>