<?php
/**
 * @var string     $path      The path to the location of the templates.
 * @var string[][] $templates The list of found templates.
 * @var mixed      $_actions  The list of available actions.
 */
?>
<div class="col-md-4 col-lg-2">
	<div class="side-bar">
		<h4 class="side-bar-header"><?= __('Email templates') ?></h4>

		<?php if (!empty($templates)) { ?>
			<div class="side-bar-list" id="TemplateList">
				<?php foreach ($templates as $template) { ?>
					<a href="#<?= $template['filename'] ?>" data-selected-value="<?= $template['filename'] ?>" data-expression="<?= htmlentities(json_encode($template['expression'])) ?>">
						<?= $template['filename'] ?>
					</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
</div>
<div class="col-md-8 col-lg-10">
	<div class="main-header with-sidebar">

		<div class="header">
			<?= $this->Format->actions($_actions) ?>
		</div>

		<div class="form">

			<?php if (empty($templates)) { ?>
				<p class="info warn text-center">
					<?= __("There are no HTML templates found.%sPlease create them in %s", '<br />', '<strong>' . $path . '</strong>') ?>
				</p>

			<?php } else { ?>

				<div data-visible-when-not="selectedTemplate">
					<p class="well">
						<?= __('Please select a template from the left side menu.') ?>
					</p>
				</div>

				<div data-visible-when="selectedTemplate" style="display: none;">
					<div class="row">
						<div class="col-md-3">

							<form id="RenderEmailForm" target="RenderEmailPreview" method="post">
								<input type="hidden" id="SelectedTemplate" name="template" value="" />

								<div data-visible-when="selectedTemplate" style="display: none">

									<div class="input clearfix no-padding">
										<textarea id="RenderEmailExpression" name="expression" placeholder="<?= __('Type the PHP code which will be evaluated before the email render here, in example') . ": \$name = 'John Smith';" ?>" style="height: 640px;"></textarea>
									</div>

									<ul class="actions">
										<li>
											<a href="javascript: void(0)" class="btn btn-primary" onclick="$(this).closest('form').submit()"><i class="fa fa-fw fa-envelope button"></i>
												Render</a>
										</li>
									</ul>
								</div>
							</form>

						</div>

						<div class="col-md-9">
							<iframe name="RenderEmailPreview" src="" width="100%" height="640" style="border: 1px solid #cdcdcd; background: white;"></iframe>
						</div>
					</div>
				</div>

				<?php if (isset($error)) { ?>
					<pre class="info issue"><?= $error ?></pre>
				<?php } ?>

				<?php if (isset($response)) { ?>
					<pre class="info ok"><?= $response ? str_replace([ '<', "	" ], [ '&lt;', '' ], print_r($response, true)) : ' ~ empty response ~ ' ?></pre>
				<?php } ?>
			<?php } ?>

		</div>
	</div>
</div>

<script type="text/javascript">

	// Submit on ctrl + enter
	$('#RenderEmailExpression').keyup(function (event) {
		if(event.ctrlKey && event.keyCode === 13) {
			$(this).closest('form').submit();
		}
		return true;
	});

	// nxSelectableChildren
	$.fn.nxSelectableChildren = function (config) {
		var parent = this;

		// Defaults
		var defaults = {
			selected: null,
			className: 'selected',
			onSelected: null
		};

		// Update config
		config = $.extend({}, defaults, typeof config !== 'function' ? config : {onSelected: config});

		// Set each
		this.children().each(function () {
			$(this).click(function (event) {

				// Remove previous selections
				parent.children().removeClass(config.className);
				$(this).addClass(config.className);

				// Set value
				var value = $(this).data('selected-value');
				parent.data('selected-value', $(this).data('selected-value'));

				// Trigger callback
				if (config.onSelected) {
					config.onSelected.call(this, value);
				}

				return event.preventDefault();
			});
		});

		// Initial selection
		if (config.selected !== null) {
			$(this.children()[config.selected]).click();
		}
	};

	// nxToggler
	window.nxToggle = function (name, value) {

		// Initialize
		var on = $('[data-visible-when="' + name + '"]');
		var off = $('[data-visible-when-not="' + name + '"]');

		// Toggle
		var val = value === 0 || value;
		if (val) {
			on.show();
			off.hide();
		} else {
			on.hide();
			off.show();
		}

		return value;
	};

	$('#TemplateList').nxSelectableChildren(function (value) {
		$('#SelectedTemplate').val(nxToggle('selectedTemplate', value));
		$('#RenderEmailExpression').val(JSON.parse($(this).data('expression')));
		$('#RenderEmailForm').submit();
	});

</script>
