<style>
	.version-log .version { padding: 1em 1em 0; margin: 22px 10px 20px; border: 1px solid #AFAFAF; }
	.version-log h3 { font-size: 200%; margin-bottom: 5px; }
	.version-log h3 span { color: #8E8E8E; }
	.version-log .section { font-size: 115%; padding: 1em 1.5em; background: rgba(0,0,0,0.08); line-height: 150%; border: 1px solid #BDBDBD; margin: 0 0 1em; }
	.version-log .sql { background: #D4D4F4; border-color: #9C9CC9; }
	.version-log .fixes { background: rgba(256, 160, 160, 0.45); border-color: #D4A5A5; }
	.version-log .improvements { background: rgba(160, 256, 160, 0.45); border-color: #ACD79A; }
	.version-log .section p { margin-top: 1em;	}
	.version-log .section ul { list-style: square; margin-left: 1em; }
	.version-log .section ul li { list-style: square; }
	.toggle-next { cursor: pointer; }
</style>

<div class="push header with-sidebar">
	<?= $this->Format->actions($_actions) ?>
</div>

<div class="index version-log">
	<?php foreach($versionLog as $i => $version) { ?>
		<div class="version">
			<h3>
				<?= !empty($version->version) ? 'v' . $version->version : '<i>in development</i>' ?><?= $isSuperadmin && !empty($version->codename) && $version->codename ? " - {$version->codename}" : null ?>
				<span> : <?= !empty($version->date) ? date('d. m. Y.', strtotime($version->date)) : null ?></span>
			</h3>

			<?php if(!empty($version->note)) { ?>
				<div class="section note" title="<?= __('Version note') ?>">
					<h4><?= __('Note') ?></h4>
					<p>
						<?= $version->note ?>
					</p>
				</div>
			<?php } ?>

			<?php if(!empty($version->improvements)) { ?>
				<div class="section improvements" title="<?= __('Improvements in this version') ?>">
					<h4><?= __('Improvements') ?></h4>
					<p>
						<ul>
							<?php foreach($version->improvements as $improvement) { ?>
								<li><?= $improvement ?></li>
							<?php } ?>
						</ul>
					</p>
				</div>
			<?php } ?>

			<?php if(!empty($version->fixes)) { ?>
				<div class="section fixes" title="<?= __('Fixes in this version') ?>">
					<h4><?= __('Fixes') ?></h4>
					<p>
						<ul>
							<?php foreach($version->fixes as $fix) { ?>
								<li><?= $fix ?></li>
							<?php } ?>
						</ul>
					</p>
				</div>
			<?php } ?>

			<?php if($isSuperadmin && !empty($version->sql)) { ?>
				<div class="section sql" title="<?= __('SQL changes in this version') ?>">
					<h4 class="toggle-next"><?= __('SQL changes') ?>: <?= substr_count(trim($version->sql), "\n") ?></h4>
					<p style="display: none">
						<?= nl2br($version->sql) ?>
					</p>
				</div>
			<?php } ?>

		</div>
	<?php } ?>
</div>

<script type="text/javascript">
	$('.toggle-next').click(function() {
		$(this).next().toggle();
	});
</script>
