<?php

// Autoload
require_once dirname(dirname(__DIR__)) . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';

// Load the dossier
define('APP', dirname(dirname(__DIR__)) . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR);
spl_autoload_register(function ($class) {
	$prefix = 'IntellexApps\\PHP\\UploadFile\\';
	if (strpos($class, $prefix) === 0) {
		$path = APP . 'Vendor' . DIRECTORY_SEPARATOR . 'dossier' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'lib' . DIRECTORY_SEPARATOR . str_replace('\\', DIRECTORY_SEPARATOR, substr($class, strlen($prefix))) . '.php';
		if (file_exists($path)) {
			include $path;
			return;
		}
	}
});

use \IntellexApps\PHP\UploadFile\Routing\Dispatcher;

(new Dispatcher())->dispatch();
