<?php
/**
 * Index
 * The Front Controller for handling every request
 * PHP 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright        Copyright 2005-2012, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link             http://cakephp.org CakePHP(tm) Project
 * @package          app.webroot
 * @since            CakePHP(tm) v 0.2.9
 * @license          MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

# Measure time
define('START_TIME', microtime(true));

# Simple user-agent blacklist
$uaBlacklist = [ 'libwww-perl' ];
if (!empty($_SERVER['HTTP_USER_AGENT']) && in_array($_SERVER['HTTP_USER_AGENT'], $uaBlacklist)) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
	die;
}

# Skip all static files
define('STATIC_EXTENSIONS', '(jpe?g|gif|png|bmp|ico|css|js|htc|swf|fla|ttf|woff|map)');
if (!empty($_SERVER['REQUEST_URI'])) {
	$static = preg_match('~\.' . STATIC_EXTENSIONS . '$~ i', preg_replace('~\?.*$~', '', $_SERVER['REQUEST_URI']));
	if ($static) {
		header('HTTP/1.1 404 Not Found', true, 404);
		exit(404);
	}
}

# AJAX or not
define('IS_AJAX', !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');

# Define the protocol
if (!empty($_SERVER['SERVER_PORT'])) {
	define('IS_HTTPS', (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443);
	define('PROTOCOL', IS_HTTPS ? 'https://' : 'http://');
}

/**
 * Use the DS to separate the directories in other defines
 */
if (!defined('DS')) {
	define('DS', DIRECTORY_SEPARATOR);
}

/**
 * These defines should only be edited if you have cake installed in
 * a directory layout other than the way it is distributed.
 * When using custom settings be sure to use the DS and do not add a trailing DS.
 */

/**
 * The full path to the directory which holds "app", WITHOUT a trailing DS.
 */
if (!defined('ROOT')) {
	define('ROOT', dirname(dirname(dirname(__FILE__))));
}
/**
 * The actual directory name for the "app".
 */
if (!defined('APP_DIR')) {
	define('APP_DIR', 'app');
}

require_once ROOT . DS . 'VectorCMS' . DS . 'Config' . DS . 'functions.conf.php';
require_once ROOT . DS . 'VectorCMS' . DS . 'Config' . DS . 'environment.conf.php';
require_once ROOT . DS . 'VectorCMS' . DS . 'Config' . DS . 'autoload.conf.php';

/**
 * Load the debugger
 */
if (class_exists('\Intellex\Debugger\Debugger')) {
	function debug($var) {
		\Intellex\Debugger\Debugger::dump($var, 1);
	}
}

// phpinfo(); die;

/**
 * The absolute path to the "cake" directory, WITHOUT a trailing DS.
 * Un-comment this line to specify a fixed path to CakePHP.
 * This should point at the directory containing `Cake`.
 * For ease of development CakePHP uses PHP's include_path.     If you
 * cannot modify your include_path set this value.
 * Leaving this constant undefined will result in it being defined in Cake/bootstrap.php
 */
//define('CAKE_CORE_INCLUDE_PATH', ROOT . DS . 'lib');

/**
 * Editing below this line should NOT be necessary.
 * Change at your own risk.
 */
if (!defined('WEBROOT_DIR')) {
	define('WEBROOT_DIR', basename(dirname(__FILE__)));
}
if (!defined('WWW_ROOT')) {
	define('WWW_ROOT', ROOT . DS . APP_DIR . DS . WEBROOT_DIR . DS);
}

if (!defined('UPLOAD_DIR')) {
	define('UPLOAD_DIR', 'upload');
}

if (!defined('HOST') && !empty($_SERVER['HTTP_HOST'])) {
	define('HOST', $_SERVER['HTTP_HOST']);
}

if (!defined('CAKE_CORE_INCLUDE_PATH')) {
	if (function_exists('ini_set')) {
		ini_set('include_path', ROOT . DS . 'lib' . PATH_SEPARATOR . ini_get('include_path'));
	}
	if (!include('Cake' . DS . 'bootstrap.php')) {
		$failed = true;
	}
} else {
	if (!include(CAKE_CORE_INCLUDE_PATH . DS . 'Cake' . DS . 'bootstrap.php')) {
		$failed = true;
	}
}
if (!empty($failed)) {
	trigger_error("CakePHP core could not be found. Check the value of CAKE_CORE_INCLUDE_PATH in APP/webroot/index.php. It should point to the directory containing your " . DS . "cake core directory and your " . DS . "vendors root directory.", E_USER_ERROR);
}

if (isset($_SERVER['PATH_INFO']) && $_SERVER['PATH_INFO'] == '/favicon.ico') {
	return;
}

# Dispatcher to handle the request
App::uses('Dispatcher', 'Routing');
$Dispatcher = new Dispatcher();

# Cronjob handler
if (isset($argc) && $argc == 2 && isCLI()) {
	define('CRONJOB', $argv[1]);
	$Dispatcher->dispatch(new CakeRequest($argv[1]), new CakeResponse());
	exit;
}

$Dispatcher->dispatch(new CakeRequest(), new CakeResponse([ 'charset' => Configure::read('App.encoding') ]));
