<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<title>Image Editor</title>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-1.9.1.min.js"></script>
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-ui.min.js"></script>
	<link rel="stylesheet" type="text/css" href="stylesheet.css" />
</head>

<body>
	<form>
		<div id="tabs">
			<ul>
				<li><a href="#image">Image</a></li>
				<li><a href="#basic">Basic</a></li>
				<li><a href="#style">Style</a></li>
				<li><a href="#link">Link</a></li>
			</ul>

			<div id="image">
				<div class="input">
					<label for="attr_alt">Alt</label>
					<div><input type="text" id="attr_alt" autocomplete="off" /></div>
				</div>

				<a href="javascript: void(0)" title="Open asset manager" onclick="$('#asset_src').toggle();resize();" style="float: right;margin: 2px 10px;">
					<img src="assetmanager/browse.png" />
				</a>
				<div class="input" style="padding-right:32px">
					<label for="attr_src">Image source</label>
					<div>
						<input type="text" id="attr_src" autocomplete="off" />
					</div>
				</div>
				<iframe id="asset_src" src=""></iframe>

				<div class="input">
					<label for="attr_width">Dimensions</label>
					<div>
						<input type="text" id="attr_width" style="width:80px" autocomplete="off" />
						x
						<input type="text" id="attr_height" style="width:80px" autocomplete="off" />
						<a href="javascript: void(0)" onclick="$('#attr_width, #attr_height').val('').change();">clear</a>
					</div>
				</div>
			</div>

			<div id="basic">
				<div class="input">
					<label for="attr_id">Id</label>
					<div><input type="text" id="attr_id" autocomplete="off" /></div>
				</div>

				<div class="input">
					<label for="attr_class">Class</label>
					<div><input type="text" id="attr_class" autocomplete="off" /></div>
				</div>
			</div>

			<div id="style">
				<div class="input">
					<label for="attr_style">Style</label>
					<div><textarea id="attr_style" rows="8"></textarea></div>
				</div>
			</div>

			<div id="link">
				<div class="input">
					<label for="link_href">URL</label>
					<div><input type="text" id="link_href" autocomplete="off" /></div>
				</div>
				<div class="input">
					<label for="link_target">New window?</label>
					<div><input type="checkbox" id="link_target" autocomplete="off" style="width:auto;margin-top:3px;" /></div>
				</div>
			</div>
		</div>

		<input type="submit" id="submit" value="OK" />
		<input type="button" id="cancel" value="Cancel" />
		<input type="button" id="delete" value="Remove image" />
		<div style="clear:both"></div>
	</form>
</body>
<script type="text/javascript" language="javascript" src="javascript.js"></script>
<script type="text/javascript" language="javascript">
	$('#asset_src').attr('src', 'assetmanager/index.php?field=attr_src&selected=' + subject.attr('src').substr(Editor.static.length));
</script>
</html>
