$('#tabs').tabs({show: resize});

/* Parse parameters */
var GET = {};
$.each(window.location.search.substr(1).split('&'), function (i, param) {
	split = param.split('=');
	eval("GET." + split[0] + " = '" + split[1] + "';");
});

var Editor = window.opener.Editor;
var subject = window.opener.subjects[GET.index];

$('[id^=attr_]').each(function (i, input) {
	var attr = $(this).attr('id').substr(5);
	var value = typeof(subject.attr(attr)) != 'undefined' ? subject.attr(attr).toString().replace(/\s*outline-.*;\s*/ug, '').replace(/;\s*/g, ';\n') : '';

	if (attr == 'src') {
		value = value.substr(Editor.static.length);
	}

	$(this).keydown(function (event) {
		if (!isNaN(parseInt($(this).val()))) {
			if (event.which == 40) {
				$(this).val(parseInt($(this).val()) - 1);
			} else if (event.which == 38) {
				$(this).val(parseInt($(this).val()) + 1);
			}
			$(this).change();
		}
	});

	$(this)
		.val(value)
		.attr('default', value)
		.keyup(function () {
			$(this).change()
		})
		.change(function () {
			var val = $(this).val();
			if (attr == 'src') {
				val = Editor.static + val;
			}
			if (isValid(val, attr)) {
				subject.attr(attr, val.replace(/\n/g, ' '));
			} else {
				subject.removeAttr(attr);
			}
		});
});

/* Content */
var content = subject.html().trim();
$('#html')
	.val(content)
	.attr('default', content)
	.keyup(function () {
		$(this).change()
	})
	.change(function () {
		subject.html($(this).val().trim());
	});

/* Tag */
var tag = subject[0].tagName.toLowerCase();
$('#tag')
	.val(tag)
	.attr('default', tag)
	.change(function () {
		var replace = $('<' + $(this).val() + '>').html(subject.html());
		subject.replaceWith(replace);
		subject = replace;
	});


/* Link */
if (subject.parent('a').length) {
	$('#link_href').val(subject.parent('a').attr('href'));
	$('#link_target').val(subject.parent('a').attr('target') == '_blank');
}

/* Validation */
function isValid(val, attr) {
	switch (attr) {
		case 'width':
		case 'height':
			return !isNaN(parseInt(val));

		default:
			return val != '';
	}
}

/* Exiting functions */
var apply = false;
$('#cancel').click(function () {
	window.close();
});
$('#submit').click(function () {
	apply = true;
	window.close();
});
$('#delete').click(function () {
	if (confirm('Are you sure you want to remove this element?')) {
		subject.remove();
		window.close();
	}
});

function revert() {
	$('#tag').val($('#tag').attr('default'));
	$('#html').val($('#html').attr('default'));
	$('[id^=attr_]').each(function (i, input) {
		$(input).val($(input).attr('default'));
	});
	$('[id^=attr_], #html, #tag').change();
}

window.onunload = function () {
	if (!apply) revert();
};

function resize() {
	if (window.innerWidth > 200) {
		window.resizeTo(window.innerWidth + 8, $('body').outerHeight(true) + 65);
	}
}

function AssetManager() {
	this.connect();
}

function editable() {

	$('textarea.contenteditable').each(function (i, textarea) {
		var iframe = $('<iframe>');
		iframe.insertAfter($(textarea));
		var $$ = iframe.contents();
		$$.find('head').append('<link media="all" rel="stylesheet" type="text/css" href="http://static.cms/css/main_20101206225411.css" />');
		$$.find('body');
		//.attr('contenteditable', true)
		//.html($(textarea).val())
		//.keyup(function() { $(textarea).val($(this).html()); $('#' + $(textarea).attr('id')).change(); })
		/*.css({
			'border': '1px solid #777',
			'padding': 4,
			'border-radius': 5});*/

		var list = [];
		var pointer = $(subject);
		while (pointer[0].tagName != 'BODY') {
			var clone = pointer.clone().html('').attr('style', '');
			if (list.length) {
				clone.css({padding: 0, margin: 0, width: 'auto', height: 'auto'})
			} else {
				clone
					.html($(textarea).val())
					.keyup(function () {
						$(textarea).val($(this).html());
						$('#' + $(textarea).attr('id')).change();
					});
			}
			list.push(clone);
			pointer = pointer.parent();
		}
		var pointer = $$.find('body');
		while (list.length) {
			pointer = list.pop().appendTo(pointer);
			if (!list.length) {
				pointer.attr('contenteditable', true);
			}
		}

		iframe.show();
		$(textarea).hide();
	});
}

$(document).ready(function () {
	setTimeout('resize()', 50);
	editable();
});
