var List = new (Plugin.extend({
    path: 'cms/list',
    icon: function(rel) {
        var id = 'ListPluginSelect_' + rel;
        var select = $('<select>')
            .attr({ id: id, rel: rel })
            .append($('<option value="">').text(' - insert module list -'))
            .change(function() {
                if($(this).val() != '') {
                    List.executeOn($(this).attr('rel'), { module: $(this).val() });
                    $(this).val('');
                } })
            .fetch('modules', function(response) {
                var options = [select.html()];
                $.each(response, function(key, value) {
                    options.push('<option value="' + key + '">' + value + '</option>');
                });
                return options.join('');
            });
        return select;
    },
    execute: function(params) {
        this.popup('list', { module: params.module });
    },
    helpers: [
        {
            selector: 'cms:list',
            action: function($this, $element) {
                return 'asdfasdf';
            }
        }
    ]
}))();
