<?php
define('ROOT', (dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))) . '/');
function debug($var) {
	if ($var) {
		$var = print_r($var, true);
		$var = str_replace('<', '&lt;', str_replace('>', '&gt;', $var));
	} else {
		ob_start();
		var_dump($var);
		$var = ob_get_clean();
	}
	$calledFrom = debug_backtrace();
	?>
	<div style="clear:both;border:1px solid black;margin:0 0 0.5em">
		<div style="padding:4px 4px 3px;background:black;color:white;font:normal 14px Trebuchet MS;letter-spacing:1px">
			<?= "{$calledFrom[0]['file']} : {$calledFrom[0]['line']}" ?>
		</div>
		<pre style="padding:1em;color:black;background:#7199CC;font:normal 15px Monotype, Courier;margin: 1px;"><?= $var ?></pre>
	</div>
	<?php
}

class MySQL extends mysqli {

	function __construct() {
		require ROOT . 'config/database.php';
		$DB = new DATABASE_CONFIG();
		parent::__construct($DB->default['host'], $DB->default['login'], $DB->default['password'], $DB->default['database']);
	}

	function query($query, $solo = false) {
		$return = [];
		$results = parent::query($query);
		if (!empty($this->error)) {
			die($this->error);
		}
		if (!is_object($results))
			return false;
		while ($result = $results->fetch_assoc()) {
			$return[] = $result;
		}
		return $solo ? (!empty($return) ? reset($return) : false) : $return;
	}
}

$sql = new MySQL();
$sql->query('SET NAMES UTF8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<title>Raw HTML</title>
	<meta name="generator" content="Geany 0.19.1" />
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-1.4.2.min.js"></script>
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-ui-1.8.4.custom.min.js"></script>
	<script type="text/javascript" language="javascript" src="/plugins/editor/wysiwyg/class.js"></script>
	<script type="text/javascript" language="javascript" src="/plugins/editor/wysiwyg/inheritance.js"></script>
	<link rel="stylesheet" type="text/css" href="forms.css" />
	<link rel="stylesheet" href="/plugins/editor/wysiwyg/stylesheet.css" type="text/css" />
	<script type="text/javascript">
		var validationError = 'no!';
		resize = function () {
			window.resizeTo($(window).outerWidth(), $('body').outerHeight() + 65);
		};

		/* Trim */
		String.prototype.trim = function () {
			return (this.replace(/^\s*|\s*$/gm, ''));
		};

		/* Prepare list of HTML attributes */
		function attributes(more) {
			var attrbs = [];

			// Parse passed attributes
			if (typeof(more) != 'undefined') {
				$.each(more, function (key, value) {
					value = value.replace(/\n/g, ' ').trim();
					if (value != '') {
						attrbs.push(key + '="' + value + '"');
					}
				});
			}

			// Parse form attributes
			$('[id^=attr_]:visible').each(function (i, input) {
				var val = $(input).val().replace(/\n/g, ' ').trim();
				if (val != '' && ($(input).attr('type') != 'checkbox' || $(input).is(':checked'))) {
					attrbs.push($(input).attr('id').replace('attr_', '') + '="' + val + '"');
				}
			});

			return attrbs.length ? ' ' + attrbs.join(' ') : '';
		}


		/* Preload */
		$.fn.preload = function (text) {
			if (typeof(text) == 'undefined') text = 'Loading, please wait';
			$(this).html(
				$('<p>').addClass('loading')
					.append($('<img>').attr('src', '../img/loadinfo.gif'))
					.append(text ? $('<span>').html(text) : '')
			);
			return $(this);
		};

		/* Loading content via ajax */
		$.fn.fetch = function (url, callback, text) {
			var url = '/editor/' + url;
			var target = $(this).preload(text);
			$.get(url, null, function (response) {
					if (typeof(callback) != 'undefined') response = callback(response);
					target.html(response);
				}
			);
			return target;
		};

		/* Validation */
		validate = function () {
			if (validationError == 'no!') return true;
			$tabs.tabs('select', validationError);
			return false;
		};
		$.fn.validate = function (what) {
			var val = $(this).val().replace(/\n/g, ' ').trim();
			var response = what(val, val == '');
			var expression = typeof(response) != 'undefined' && response != true;

			$(this).next('span.error').remove();
			$(this).closest('.input.error').removeClass('error');
			if (expression) {
				$(this).closest('.input').addClass('error');
				$(this).after($('<span class="error">').html(response));
				validationError = $(this).closest('div.tabs > div').prevAll().length - 1;
			}

			resize();
			return expression;
		};

		/* Close window on ESC */
		$(window).keyup(function (event) {
			if (event.keyCode == 27) {
				window.close();
			}
		});
	</script>
</head>

<body>
<?php
if (!empty($_GET['content']) && is_readable($_GET['content'] . '.html')) {
	$content = explode('/', $_GET['content']);
	end($content);
	$className = ucfirst(prev($content));
	echo '<script type="text/javascript">var This = window.opener.' . $className . ';</script>';
	require($_GET['content'] . '.html');
}
?>
</body>
<script type="text/javascript" language="javascript">
	var $tabs = $('.tabs').tabs({
		show: function () {
			resize();
		}
	});

	resize();
	$(document).ready(function () {
		resize();
		setTimeout('resize()', 50);
	});

	$('#cancel').click(function () {
		window.close();
	});

	/* Auto resize radio and checkbox inputs */
	$('input[type=radio], input[type=checkbox]').css({'width': 'auto', 'margin': '7px 0 0'});

	/*var apply = false;
	var body = $(window.opener.document).find('#iframe').contents().find('body');
	var backup = body.html();

	$('textarea')
		.val(backup)
		.keyup(function() { $(this).change() } )
		.change(function() {
			body.html($(this).val());
		});

	$(document).ready(function() {
		$('textarea').height($(window).height() - 40);
	});

	$('#submit').click(function() {
		apply = true;
		window.close();
	});

	window.onunload = function() {
		if(!apply) {
			body.html(backup);
		}
		window.opener.startUp();
	};*/
</script>
</html>
