//# sourceURL=transition-blinds.js

ShowUpTransition.blinds = jQuery.extend( {}, ShowUpTransition._defaultTransition, {

	options: {
		count: 16,
		easing: 'easeOutQuad',
		type: 'left',

		delay: 15,
		duration: 300
	},

	setDefaults: function(content, width, height) {
		var types = [ 'top', 'right', 'bottom', 'left' ];

		// Limit the count
		this.options.count = Math.min(100, this.options.count);

		// Set constants
		this._Delay = this.options.delay * ShowUp.options.duration;
		this._Duration = this.options.duration * ShowUp.options.duration;
		this._Type = this.options.type == 'random' ? types[Math.floor(Math.random()*types.length)] : this.options.type;
		this._Width = width / this.options.count;
		this._Height = height / this.options.count;

		// Return defaults
		return {
			w: this._Width,
			h: height
		};
	},

	apply: function(content, width, height) {
		var slices = [];

		var opacity = { property: 'opacity', value: 0, delay: this._Delay, duration: 2*this._Duration };

		var i = -1;
		while(++i < this.options.count) {

			if(this._Type == 'top') {

				var slice = {
					y: i*this._Height,
					w: width,
					h: this._Height,
					animations : [
						{ property: 'top', value: (2+i)*this._Height, delay: i*this._Delay, duration: this._Duration },
						{ property: 'height', value: 0, delay: i*this._Delay, duration: this._Duration },
						opacity
					]
				};

			} else if(this._Type == 'bottom') {
				var slice = {
					y: (this.options.count - i - 1) * this._Height,
					w: width,
					h: this._Height,
					animations : [
						{ property: 'bottom', value: (2+i)*this._Height, delay: i*this._Delay, duration: this._Duration },
						{ property: 'height', value: 0, delay: i*this._Delay, duration: this._Duration },
						opacity
					]
				};

			} else if(this._Type == 'left') {
				var slice = {
					x: i*this._Width,
					w: this._Width,
					h: height,
					animations : [
						{ property: 'left', value: (2+i)*this._Width, delay: i*this._Delay, duration: this._Duration },
						{ property: 'width', value: 0, delay: i*this._Delay, duration: this._Duration },
						opacity
					]
				};

			} else if(this._Type == 'right') {
				var slice = {
					x: (this.options.count - i - 1) * this._Width,
					w: this._Width,
					h: height,
					animations : [
						{ property: 'right', value: (2+i)*this._Width, delay: i*this._Delay, duration: this._Duration },
						{ property: 'width', value: 0, delay: i*this._Delay, duration: this._Duration },
						opacity
					]
				};
			}

			slices.push(slice);
		}

		return slices;
	}

});
