//# sourceURL=transition-blocks.js

ShowUpTransition.blocks = jQuery.extend({}, ShowUpTransition._defaultTransition, {

	options: {
		grid: '5x5',
		type: 'forward',

		effect: 'fade',

		delay: 200,
		duration: 400
	},

	setDefaults: function (content, width, height) {
		var types = [
			'forward', 'backward', 'center',
			'top-left', 'top-right', 'bottom-right', 'bottom-left',
			'top', 'right', 'left', 'bottom',
			'random'];

		// Limit the count
		var split = this.options.grid.split('x');
		split[0] = Math.min(20, split[0]);
		split[1] = Math.min(20, split[1]);
		this.options.grid = split[0] + 'x' + split[1];

		// Set constants
		this._X = split[0] * 1;
		this._Y = split[1] * 1;
		this._Type = this.options.type == 'random' ? types[Math.floor(Math.random() * types.length)] : this.options.type;
		this._Effect = this.options.effect,
			this._Delay = this.options.delay * ShowUp.options.duration;
		this._Duration = this.options.duration * ShowUp.options.duration;
		this._Width = width / this._X;
		this._Height = height / this._Y;

		// Return defaults
		return {
			w: this._Width,
			h: this._Height
		}
	},

	apply: function (content, width, height) {
		var slices = [];

		var i = -1;
		while (++i < this._X) {

			var j = -1;
			while (++j < this._Y) {

				var sqrt = (i + j) / 2;

				switch (this._Type) {

					// Corner
					default:
					case 'top-left':
						sqrt = (i + j) / 2;
						break;

					case 'top-right':
						sqrt = (this._X - i + j) / 2;
						break;

					case 'bottom-right':
						sqrt = (this._X - i + this._Y - j) / 2;
						break;

					case 'bottom-left':
						sqrt = (i + this._Y - j) / 2;
						break;

					// Side direction
					case 'top':
						sqrt = (Math.abs(this._X / 2 - i) + j) / 4;
						break;

					case 'right':
						sqrt = (0 - i + Math.abs(this._Y / 2 - j)) / 4;
						break;

					case 'bottom':
						sqrt = (Math.abs(this._X / 2 - i) - j) / 4;
						break;

					case 'left':
						sqrt = (i + Math.abs(this._Y / 2 - j)) / 4;
						break;

					// Polydirectional
					case 'center':
						sqrt = (Math.abs(this._X / 2 - i) + Math.abs(this._Y / 2 - j)) / 4;
						break;

					case 'forward':
						sqrt = Math.abs((this._X + this._Y - 2) / 4 - (i + j) / 2);
						break;

					case 'backward':
						var max = (this._X + this._Y - 2) / 4;
						sqrt = max - Math.abs(max - (i + j) / 2);
						break;

				}

				// Set the animation
				var animations = [{
					property: 'opacity',
					value: 0,
					duration: this._Duration,
					delay: this._Delay * sqrt
				}];

				// Zoom effect
				if (this._Effect == 'zoom') {
					animations.push({
						property: 'left',
						value: i * this._Width + this._Width / 2,
						duration: this._Duration,
						delay: this._Delay * sqrt
					});
					animations.push({
						property: 'width',
						value: 0,
						duration: this._Duration,
						delay: this._Delay * sqrt
					});
					animations.push({
						property: 'top',
						value: j * this._Height + this._Height / 2,
						duration: this._Duration,
						delay: this._Delay * sqrt
					});
					animations.push({
						property: 'height',
						value: 0,
						duration: this._Duration,
						delay: this._Delay * sqrt
					});
				}

				//animations.push({ property: 'border-radius', value: '50%', duration: this._Duration*2, delay: this._Delay * sqrt });

				var slice = {
					x: i * this._Width,
					y: j * this._Height,
					animations: animations
				};

				slices.push(slice);
			}
		}

		return slices;
	}

});
