//# sourceURL=transition-spiral.js

ShowUpTransition.spiral = jQuery.extend({}, ShowUpTransition._defaultTransition, {

	options: {
		grid: '5x5',
		start: 'random',
		direction: 'random',
		reverse: 'random',

		delay: 20,
		duration: 450
	},

	setDefaults: function (content, width, height) {
		var startOptions = [
			'top-left', 'top-right', 'bottom-right', 'bottom-left',
			'random'];
		var directionOptions = [
			'CW', 'CCW',
			'random'];
		var reverseOptions = [
			'no', 'yes',
			'random'];

		// Limit the count
		var split = this.options.grid.split('x');
		split[0] = Math.min(20, split[0]);
		split[1] = Math.min(20, split[1]);
		this.options.grid = split[0] + 'x' + split[1];

		// Set constants
		this._X = split[0] * 1;
		this._Y = split[1] * 1;
		this._Start = this.options.start == 'random' ? startOptions[Math.floor(Math.random() * (startOptions.length - 1))] : this.options.start;
		this._Direction = this.options.direction == 'random' ? directionOptions[Math.floor(Math.random() * (directionOptions.length - 1))] : this.options.direction;
		this._Reverse = this.options.reverse == 'random' ? reverseOptions[Math.floor(Math.random() * (reverseOptions.length - 1))] : this.options.reverse;
		this._Delay = this.options.delay * ShowUp.options.duration;
		this._Duration = this.options.duration * ShowUp.options.duration;
		this._Width = width / this._X;
		this._Height = height / this._Y;

		// Return defaults
		return {
			w: this._Width,
			h: this._Height
		}
	},

	apply: function (content, width, height) {
		var slices = [];

		var order = this.getSpiralOrder(this._X, this._Y, this._Start, this._Direction, this._Reverse);

		for (var i = 0; i < order.length; i++) {
			var animations = [{
				property: 'opacity',
				value: 0,
				duration: this._Duration,
				delay: this._Delay * i
			}];

			var slice = {
				x: order[i].x * this._Width,
				y: order[i].y * this._Height,
				animations: animations
			};

			slices.push(slice);
		}

		return slices;
	},

	getSpiralOrder: function (width, height, start, direction, reverse) {
		reverse = reverse === 'yes';

		var order = [],
			currentField = {
				x: (start == 'top-left' || start == 'bottom-left') ? 0 : width - 1,
				y: (start == 'top-left' || start == 'top-right') ? 0 : height - 1
			},
			moveVectors =
				direction == 'CW' ?
					[{x: 1, y: 0, dir: 'right'}, {x: 0, y: 1, dir: 'down'}, {
						x: -1,
						y: 0,
						dir: 'left'
					}, {x: 0, y: -1, dir: 'up'}] :
					[{x: 1, y: 0, dir: 'right'}, {x: 0, y: -1, dir: 'up'}, {
						x: -1,
						y: 0,
						dir: 'left'
					}, {x: 0, y: 1, dir: 'down'}],
			curVector = -1,
			limits = {
				right: width,
				down: height,
				left: -1,
				up: -1
			};

		if (start == 'top-left' && direction == 'CW' || start == 'bottom-left' && direction == 'CCW') {
			curVector = 0;
		}
		else if (start == 'top-right' && direction == 'CW' || start == 'bottom-right' && direction == 'CCW') {
			curVector = 1;
		}
		else if (start == 'bottom-right' && direction == 'CW' || start == 'top-right' && direction == 'CCW') {
			curVector = 2;
		}
		else if (start == 'bottom-left' && direction == 'CW' || start == 'top-left' && direction == 'CCW') {
			curVector = 3;
		}

		while (currentField !== null) {
			order.push(currentField);

			var newField = {
				x: currentField.x + moveVectors[curVector].x,
				y: currentField.y + moveVectors[curVector].y
			};

			if (newField.x > limits.left && newField.x < limits.right && newField.y > limits.up && newField.y < limits.down) {
				currentField = newField;
			}
			else {
				curVector = (curVector + 1) % 4;
				switch (moveVectors[curVector].dir) {
					case 'down':
						limits.up++;
						break;
					case 'left':
						limits.right--;
						break;
					case 'up':
						limits.down--;
						break;
					case 'right':
						limits.left++;
						break;
				}
				newField = {
					x: currentField.x + moveVectors[curVector].x,
					y: currentField.y + moveVectors[curVector].y
				};
				if (newField.x > limits.left && newField.x < limits.right && newField.y > limits.up && newField.y < limits.down) {
					currentField = newField;
				}
				else {
					currentField = null;
				}
			}
		}

		for (var i = 0, temp, len = order.length; reverse && i < len / 2; i++) {
			temp = order[i];
			order[i] = order[len - 1 - i];
			order[len - 1 - i] = temp;
		}

		return order;
	}

});
