//# sourceURL=transition-stripes.js

ShowUpTransition.stripes = jQuery.extend( {}, ShowUpTransition._defaultTransition, {

	options: {
		count: 16,
		easing: 'easeOutQuad',
		type: 'vertical',
		direction: 'left',

		delay: 27,
		duration: 380
	},

	setDefaults: function(content, width, height) {

		// Limit the count
		this.options.count = Math.min(100, this.options.count);

		// Set constants
		this._Delay = this.options.delay * ShowUp.options.duration;
		this._Duration = this.options.duration * ShowUp.options.duration;
		this._Type = this.options.type == 'random' ? Math.random() > 0.5 ? 'vertical' : 'horizontal' : this.options.type;
		this._Width = width / this.options.count;
		this._Height = height / this.options.count;

		// Set the directions
		var directions = ['inside', 'outside'];
		switch(this._Type) {
			case 'vertical':
				directions.push('top'); directions.push('bottom');
				break;

			case 'horizontal':
				directions.push('left'); directions.push('right');
				break;
		}
		this._Direction = this.options.direction == 'random' ? items[Math.floor(Math.random()*directions.length)] : this.options.direction;

		// Return defaults
		return {
			w: this._Width,
			h: height
		}
	},

	apply: function(content, width, height) {
		var slices = [];

		var i = -1;
		while(++i < this.options.count) {

			switch(this._Type) {
				case 'horizontal':
					var base = width/10;

					// Get the direction
					var c = i;
					switch(this._Direction) {
						default:
						case 'top':		c = i; break;
						case 'bottom':	c = this.options.count - i; break;
						case 'outer':	c = Math.abs(this.options.count / 2 - i); break;
						case 'inner':	c = this.options.count / 2 - Math.abs(this.options.count / 2 - i); break;
					}

					// Define the slice
					var slice = {
						y: i*this._Height,
						w: width,
						h: this._Height,
						animations : [
							{ property: 'left', value: i%2 ? base : -base, delay: c*this._Delay, duration: this._Duration },
							{ property: 'opacity', value: 0, delay: c*this._Delay, duration: this._Duration * 2 }
						]
					};
					break;

				case 'vertical':
					var base = height / 5;

					// Get the direction
					var c = i;
					switch(this._Direction) {
						default:
						case 'left':	c = i; break;
						case 'right':	c = this.options.count - i; break;
						case 'outer':	c = Math.abs(this.options.count / 2 - i); break;
						case 'inner':	c = this.options.count / 2 - Math.abs(this.options.count / 2 - i); break;
					}

					// Define the slice
					var slice = {
						x: i*this._Width,
						w: this._Width,
						h: height,
						animations : [
							{ property: 'top', value: i%2 ? base : -base, delay: c*this._Delay, duration: this._Duration },
							{ property: 'opacity', value: 0, delay: c*this._Delay, duration: this._Duration * 2 }
						]
					};
					break;
			}

			slices.push(slice);
		}

		return slices;
	}

});
