<?php
	require_once 'include.php';

	# Get files
	$files = scanrdir(ROOT, $ignore);
	$original = unserialize(file_get_contents('result'));

	# Find new/missing files
	$new = array_diff_key($files, $original);
	$missing = array_diff_key($original, $files);

	# Get modified files
	$modified = array_diff($files, $original, $new);

	# Build response
	$summary = !empty($new)*1 + !empty($missing)*2 + !empty($modified)*4;
	header('Content-type: application/xml');
	echo '<?xml version="1.0" encoding="UTF-8"?>';
?>

<root>
	<summary><?= $summary ?></summary>
	<new>
<?php foreach($new as $file => $hash) { ?>
		<file>
			<path><?= $file ?></path>
			<modified><?= date('Y-m-d H:i:s', filemtime($file)) ?></modified>
			<?php if(is_ascii($file)) { ?>
				<content><![CDATA[<?= str_replace(']]>', ']]_>', (file_get_contents($file))) ?>]]></content>
			<?php } else { ?>
				<content><![CDATA[<?= "binary (size: " . filesize($file) . ")" ?>]]></content>
			<?php } ?>
		</file>
<?php } ?>
	</new>
	<missing>
<?php foreach($missing as $file => $hash) { ?>
		<file>
			<path><?= $file ?></path>
		</file>
<?php } ?>
	</missing>
	<modified>
<?php foreach($modified as $file => $hash) { ?>
		<file>
			<path><?= $file ?></path>
			<modified><?= date('Y-m-d H:i:s', filemtime($file)) ?></modified>
			<?php if(is_ascii($file)) { ?>
				<content><![CDATA[<?= str_replace(']]>', ']]_>', (file_get_contents($file))) ?>]]></content>
			<?php } else { ?>
				<content><![CDATA[<?= "binary (size: " . filesize($file) . ")" ?>]]></content>
			<?php } ?>
		</file>
<?php } ?>
	</modified>
	<meta>
		<ip><?= $_SERVER['REMOTE_ADDR'] ?></ip>
		<version>1</version>
		<cached><?= date('Y-m-d H:i:s') ?></cached>
		<error />
		<generated><?= round(1000 * (microtime(true) - START_TIME)) ?></generated>
	</meta>
</root>
