<!DOCTYPE html>
<html lang="en">

	<head>

		<meta charset="utf-8">
		<title>Intellex</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="">
		<meta name="author" content="">

		<!-- CSS -->
		<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Lobster">
		<link rel='stylesheet' href='http://fonts.googleapis.com/css?family=Lato:400,700'>
		<link rel="stylesheet" href="/assets/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="/assets/css/style.css">

		<!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
		<!--[if lt IE 9]>
			<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
		<![endif]-->

		<!-- Favicon and touch icons -->
		<link rel="shortcut icon" href="/assets/ico/favicon.ico">
		<link rel="apple-touch-icon-precomposed" sizes="144x144" href="/assets/ico/apple-touch-icon-144-precomposed.png">
		<link rel="apple-touch-icon-precomposed" sizes="114x114" href="/assets/ico/apple-touch-icon-114-precomposed.png">
		<link rel="apple-touch-icon-precomposed" sizes="72x72" href="/assets/ico/apple-touch-icon-72-precomposed.png">
		<link rel="apple-touch-icon-precomposed" href="/assets/ico/apple-touch-icon-57-precomposed.png">


		<script src="/assets/js/jquery-1.8.2.min.js"></script>
		<script src="/assets/bootstrap/js/bootstrap.min.js"></script>

	</head>

	<body>

		<!-- Header -->
		<div class="container">
			<div class="header row">
				<div class="logo span4">
					<h1><a href="http://intellex.rs" target="_blank"><img src="/assets/img/intellex_logo.png" height="30" ></a></h1>
				</div>
				<div class="call-us span8">
					<p>Tel: <span>+381 11 40 88 222</span> | Email: <span>inbox@intellex.rs</span></p>
				</div>
			</div>
		</div>

		<!-- Coming Soon -->
		<div class="coming-soon">
			<div class="inner-bg">
				<div class="container">
					<div class="row">
						<div class="span12">
							<h2>We're Coming Soon</h2>
							<p>We are working very hard on the new version of our site. It will bring a lot of new features. Stay tuned!</p>

							<?php
								#include(__DIR__. '/assets/inc/countdown.php');
							?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Content -->
		<div class="container">
			<div class="row">
				<div class="span12 subscribe">
					<h3>Subscribe to our newsletter</h3>
					<p>Sign up now to our newsletter and you'll be one of the first to know when the site is ready:</p>
					<form class="form-inline" action="/assets/sendmail.php" method="post">
						<input type="text" name="email" placeholder="Enter your email...">
						<button type="submit" class="btn btn-default">Subscribe</button>
					</form>
					<div class="success-message"></div>
					<div class="form-input-error-message"></div>
				</div>
			</div>
			<div class="row">
				<div class="span12 social">
					<a href="https://www.facebook.com/intellexapps" class="facebook" rel="tooltip" data-placement="top" data-original-title="Facebook"></a>
					<a href="https://twitter.com/intellexapps" class="twitter" rel="tooltip" data-placement="top" data-original-title="Twitter"></a>
<!--
					<a href="" class="dribbble" rel="tooltip" data-placement="top" data-original-title="Dribbble"></a>
					<a href="" class="googleplus" rel="tooltip" data-placement="top" data-original-title="Google Plus"></a>
					<a href="" class="pinterest" rel="tooltip" data-placement="top" data-original-title="Pinterest"></a>
					<a href="" class="flickr" rel="tooltip" data-placement="top" data-original-title="Flickr"></a>
-->
				</div>
			</div>
		</div>

		<!-- Javascript -->
		<script src="/assets/js/jquery.backstretch.min.js"></script>
		<script type="text/javascript">
			jQuery(document).ready(function() {

				/*
					Background slideshow
				$('.coming-soon').backstretch([
					  "assets/img/backgrounds/1.jpg"
					, "assets/img/backgrounds/2.jpg"
					, "assets/img/backgrounds/3.jpg"
					], {duration: 3000, fade: 750});
				*/

				/*
					Tooltips
				*/
				$('.social a.facebook').tooltip();
				$('.social a.twitter').tooltip();
				$('.social a.dribbble').tooltip();
				$('.social a.googleplus').tooltip();
				$('.social a.pinterest').tooltip();
				$('.social a.flickr').tooltip();

				/*
					Subscription form
				*/
				$('.success-message').hide();
				$('.form-input-error-message').hide();

				$('.subscribe form').submit(function() {
					var postdata = $('.subscribe form').serialize();
					$.ajax({
						type: 'POST',
						url: 'assets/sendmail.php',
						data: postdata,
						dataType: 'json',
						success: function(json) {
							if(json.valid == 0) {
								$('.success-message').hide();
								$('.form-input-error-message').hide();
								$('.form-input-error-message').html(json.message);
								$('.form-input-error-message').fadeIn();
							}
							else {
								$('.form-input-error-message').hide();
								$('.success-message').hide();
								$('.subscribe form').hide();
								$('.success-message').html(json.message);
								$('.success-message').fadeIn();
							}
						}
					});
					return false;
				});

			});
		</script>
	</body>
</html>
