<?php
error_reporting(0);
define(ROOT, '../../../../');
class Status {
	private $errors = null;

# ~ Entry point for health status check	 - - - - - - - - - - - - - - - - - - - #
	public function Status() {

		# Run the tests
		$this->enviroment();
		$this->mysql();
		$this->disk();

		# Response
		$response = array(
			'success' => empty($this->errors),
			'errors' => !empty($this->errors) ? $this->errors : null
		);

		header('Content-type: application/json');
		echo json_encode($response);
		exit;
	}


# ~ Get the configuration  - - - - - - - - - - - - - - - - - - - - - - - - - - #
	private function getDatabaseConnection() {

		# Get the configuration
		require ROOT . '/app/Config/config.php';
		$config = new DATABASE_CONFIG();

		# Return the array
		return array(
			'host' => $config->default['host'],
			'user' => $config->default['login'],
			'pass' => $config->default['password'],
			'database' => $config->default['database']
		);
	}


# ~ Check the enviroment - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	private function enviroment() {

		# Configuration file
		if(!is_readable(ROOT . '/app/Config/config.php')) {
			$this->error('Config file is not readable');
			return;
		}

		# Writtable folders
		$folders = array(
			'Backups',
			'webroot/assets',
			'webroot/thumbs',
			'webroot/upload',

			'tmp',
			'tmp/logs',
			'tmp/tests',
			'tmp/upload',
			'tmp/sessions',
			'tmp/cache',
			'tmp/cache/data',
			'tmp/cache/live',
			'tmp/cache/view',
			'tmp/cache/format',
			'tmp/cache/models',
			'tmp/cache/persistent'
		);

		# Check writtable folders
		foreach($folders as $folder) {
			if(!is_writable(ROOT . 'app/' . $folder)) {
				$this->error("Not writable: {$folder}");
			}
		}
	}


# ~ Check MySQL	 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	private function mysql() {
		$this->Database = new Mysqli();

		# Get the mysql configuration
		$conf = $this->getDatabaseConnection();

		# Try to connect
		if(!$this->Database->real_connect($conf['host'], $conf['user'], $conf['pass'], $conf['database'])) {
			$this->Database->error;
			$this->error('Cannot connect to database');

		# Try query
		} elseif(!$this->Database->query("SELECT `id` FROM `administrators`")) {
			$this->Database->error;
			$this->error('Cannot query the database');
		}
	}


# ~ Check remaninig space on disk  - - - - - - - - - - - - - - - - - - - - - - #
	private function disk() {

		# Get the values
		$free = disk_free_space('/');
		$total = disk_total_space('/');

		# Make sure we have at least 20% available
		if(($percentage = round(100 * $free / $total)) < 20) {
			$this->error("Disk space critical: {$percentage}%");
		}
	}


# ~ Throw an error - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	private function error($error, $key = null) {
		$backtrack = debug_backtrace();
		$this->errors[$key ? $key : $backtrack[1]['function']][] = $error;
	}
}

new Status();


# No to crash while loading database config
class Configure { public function write() {} }
