<?php

abstract class CategoryBaseModel extends AppModel {
	public $cache = false;

	public function customIndexRestrictions() {

		# Get the Categories
		$category = $this->getCategory();
		$categories = ClassRegistry::init($category)->find('list', [
			'fields' => [ 'id', 'title' ]
		]);

		# Build the list
		$options = [ __('Show All') => null ];
		foreach ($categories as $id => $category) {
			$options[$category] = [ "{$this->alias}." . $this->getCategoryField() => $id ];
		}
		return $options;
	}

	protected function getCategoryField() {
		return 'cms_' . Inflector::underscore($this->getCategory()) . '_id';
	}

	/**
	 * Get the parent category module for this module.
	 *
	 * @return string The name of the category module.
	 */
	abstract protected function getCategory();

}
