<?php
App::uses('AppModel', 'Model');

class CmsRequestForm extends AppModel {

	public $cache = false;

	public function isAddable() {
		return false;
	}

	function initValidation() {
		return [
			'name'    => [
				'notBlank' => [
					'rule'     => [ 'notBlank' ],
					'required' => true,
					'message'  => __('Please provide name') ] ],
			'registration_number'   => [
				'notBlank' => [
					'rule'     => 'numeric',
					'required' => true,
					'message'  => __('Please provide valid registration number') ],
				'minLength' => [
					'rule'     => [ 'minLength', 8 ],
					'required' => true,
					'message'  => __('Please provide valid registration number') ],
				'maxLength' => [
					'rule'     => [ 'maxLength', 8 ],
					'required' => true,
					'message'  => __('Please provide valid registration number') ] ],
			'contact_person' => [
				'notBlank' => [
					'rule'     => [ 'notBlank' ],
					'required' => true,
					'message'  => __('Please enter Name of Contact Person') ] ],
			'phone' => [
				'notBlank' => [
					'rule'     => [ 'notBlank' ],
					'required' => true,
					'message'  => __('Please provide phone') ] ],
			'email'   => [
				'notBlank' => [
					'rule'     => 'email',
					'required' => true,
					'message'  => __('Please provide valid email') ] ],
		];
	}

}
