<?php
class SeoAppModel extends Model {

	# Instance model.
	var $modelInstance;

	# Model name.
	var $model = '';

	# Model data.
	var $data = array();

	# Candidates for title.
	var $titleCandidates = array('title', 'name');

	# Candidates for description
	var $descriptionCandidates = array('description', 'full_text', 'details', 'text');


/**
 * Generate metadata.
 *
 * @param modelName
 *		Name of model.
 * @param modelData
 *		Model data.
 * @return	metadata
 *		Array with metadata.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	public function getMetaData($modelName, $modelData) {

		# Initialize variabes.
		$this->model = $modelName;
		$this->data = $modelData;

		# Fill metadata array and return it.
		$metadata = array();
		$this->modelInstance = ClassRegistry::init($this->model);
		$metadata['title'] = $this->getMetaTitle();
		$metadata['description'] = $this->getMetaDescription();
		$metadata['keywords'] = $this->getMetaKeywords();
		$metadata['image'] = $this->getMetaImage();

		return $metadata;
	}

/**
 * Gets meta title. If there is no one from specific generator, returns default.
 *
 * @return	title
 *		Meta title.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	function getMetaTitle() {
		$customTitle = $this->getTitle();
		if(!empty($customTitle)) return $customTitle;

		if(isset($this->data[$this->model]['meta_title'])) {
			return $this->data[$this->model]['meta_title'];
		}
	}

/**
 * Gets meta description. If there is no one from specific generator, returns default.
 *
 * @return	description
 *		Meta description.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	function getMetaDescription() {
		$customDesc = $this->getDescription();
		if(!empty($customDesc)) return $customDesc;

		if(isset($this->data[$this->model]['meta_description'])) {
			return $this->data[$this->model]['meta_description'];
		}
	}

/**
 * Gets meta keywords. If there is no one from specific generator, returns default.
 *
 * @return	keywords
 *		Meta keywords.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	function getMetaKeywords() {
		$customKeyw = $this->getKeywords();
		if(!empty($customKeyw)) return $customKeyw;

		if(isset($this->data[$this->model]['meta_keywords'])) {
			return $this->data[$this->model]['meta_keywords'];
		}

		if(isset($this->data[$this->model]['meta_keyword'])) {
			return $this->data[$this->model]['meta_keyword'];
		}
	}

/**
 * Gets meta image. If there is no one from specific generator, returns default.
 *
 * @return	image
 *		Meta image.
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	function getMetaImage() {
		$customImage = $this->getImage();
		if(!empty($customImage)) return $customImage;

		if(!empty($this->data['MetaImages'])) {
				$imageNo = rand(0,count($this->data['MetaImages']) -1);
				return FRONT_BASE_URL . $this->data['MetaImages'][$imageNo]['file'];
		}
	}


# Methods to reimplement in specific generators.
	function getDescription() {
	}

	function getTitle() {
	}

	function getKeywords(){
	}

	function getImage() {
	}

}
?>
