<?php
	$languages = ClassRegistry::init('Language')->find('all', []);
?>

<header>
	<div class="inner clearfix">

		<div class="logo">
			<a href="<?= '/' . $locale . '/'?>"><img src="/img/euroaudit-logo-color.png" /></a>
		</div>

		<div class="off-canvas-right">
			<div class="lang">
				<ul>
					<?php foreach ($languages as $language) { ?>
						<li class="<?php echo $locale === $language['Language']['locale'] ? 'active' : '' ?>">
							<a href="<?php echo $locale === $language['Language']['locale'] ? 'javascript:void(0)' : '/' . $locale . ':' . $language['Language']['locale'] . $localelessHere ?>"><?= $language['Language']['title'] ?></a>
						</li>
					<?php } ?>
				</ul>
			</div>
			<nav>
				<ul>
					<?= $this->Format->printMenu('nav/top') ?>
				</ul>
			</nav>
		</div>

		<div class="hamburger hamburger--squeeze js-hamburger" id="openRightMenu">
			<div class="hamburger-box">
				<div class="hamburger-inner"></div>
			</div>
		</div>

	</div>
</header>