<?php
	$services = ClassRegistry::init('Service')->find('all', [
		'recursive' => -1
	]);

$settings = ClassRegistry::init('Setting')->find('first', []);

?>

<footer>
    <div class="inner clearfix">
        <div class="row">
            <div class="column __3 st__6 logo-holder">
				<div class="logo"><a href="<?= '/' . $locale . '/'?>"><img src="/img/euroaudit-logo-grey.png" /></a></div>
				<p>&copy; <?= date('Y')?>. Copyright EuroAudit.d.o.o.</p>
			</div>
            <div class="column __2 st__2">
                <h3>EuroAudit</h3>
                <ul>
                    <?= $this->Format->printMenu('nav/footer', 13)?>
                </ul>
            </div>
            <div class="column __3 st__2">
                <h3>Naše usluge</h3>
                <ul>
					<?php foreach ($services as $service) { ?>
						<li><a href="<?= $this->Format->getPageFromSitemap(5, $sitemap, 'path') . '#' . str_replace(' ', '', $service['Service']['title'])?>"><?= $service['Service']['title'] ?></a></li>
					<?php } ?>
                </ul>
            </div>
            <div class="column __4 st__2">
                <h3>Kontakt</h3>
                <ul>
					<li><strong>Adresa:</strong> <?= $settings['Setting']['address'] ?></li>
					<li><strong>Telefoni:</strong> <?= $settings['Setting']['phone'] ?></li>
					<li><strong>Fax:</strong> <?= $settings['Setting']['fax'] ?></li>
					<li><strong>Email:</strong> <a href="mailto:<?= $settings['Setting']['email'] ?>"><?= $settings['Setting']['email'] ?></a></li>
                </ul>
            </div>
        </div>
    </div>
	<div class="footer-b"></div>
</footer>