<?php

use Newsletter\Builder\TemplateHelper;


$requiredVars = [
	'custom'      => [
		'title' => 'Signature',
		'type'  => 'string'
	],
];

extract(\Newsletter\Builder\Parser::parse($requiredVars, isset($_data) ? $_data : null));

?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8"> <!-- utf-8 works for most cases -->
	<meta name="viewport" content="width=device-width"> <!-- Forcing initial-scale shouldn't be necessary -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge"> <!-- Use the latest (edge) version of IE rendering engine -->
	<meta name="x-apple-disable-message-reformatting">  <!-- Disable auto-scale in iOS 10 Mail entirely -->
	<title>Newsletter template</title> <!-- The title tag shows in email notifications, like Android 4.4. -->

	<!-- Web Font / @font-face : BEGIN -->
	<!-- NOTE: If web fonts are not required, lines 10 - 27 can be safely removed. -->

	<!-- Desktop Outlook chokes on web font references and defaults to Times New Roman, so we force a safe fallback font. -->
	<!--[if mso]>
	<style>i
	* {
		font-family: sans-serif !important;
	}
	</style>
	<![endif]-->

	<!-- All other clients get the webfont reference; some will render the font and others will silently fail to the fallbacks. More on that here: http://stylecampaign.com/blog/2015/02/webfont-support-in-email/ -->
	<!--[if !mso]><!-->
	<!-- insert web font reference, eg: <link href='https://fonts.googleapis.com/css?family=Roboto:400,700' rel='stylesheet' type='text/css'> -->
	<!--<![endif]-->

	<!-- Web Font / @font-face : END -->

	<!-- CSS Reset -->
	<style>

		/* What it does: Remove spaces around the email design added by some email clients. */
		/* Beware: It can remove the padding / margin and add a background color to the compose a reply window. */
		html,
		body {
			margin: 0 auto !important;
			padding: 0 !important;
			height: 100% !important;
			width: 100% !important;
		}

		p {
			margin: 0;
		}

		/* What it does: Stops email clients resizing small text. */
		* {
			-ms-text-size-adjust: 100%;
			-webkit-text-size-adjust: 100%;
		}

		/* What it does: Centers email on Android 4.4 */
		div[style*="margin: 16px 0"] {
			margin:0 !important;
		}

		/* What it does: Stops Outlook from adding extra spacing to tables. */
		table,
		td {
			mso-table-lspace: 0pt !important;
			mso-table-rspace: 0pt !important;
		}

		/* What it does: Fixes webkit padding issue. Fix for Yahoo mail table alignment bug. Applies table-layout to the first 2 tables then removes for anything nested deeper. */
		table {
			border-spacing: 0 !important;
			border-collapse: collapse !important;
			table-layout: fixed !important;
			margin: 0 auto !important;
		}
		table table table {
			table-layout: auto;
		}

		/* What it does: Uses a better rendering method when resizing images in IE. */
		img {
			-ms-interpolation-mode:bicubic;
		}

		/* What it does: A work-around for iOS meddling in triggered links. */
		*[x-apple-data-detectors] {
			color: inherit !important;
			text-decoration: none !important;
		}

		/* What it does: A work-around for Gmail meddling in triggered links. */
		.x-gmail-data-detectors,
		.x-gmail-data-detectors *,
		.aBn {
			border-bottom: 0 !important;
			cursor: default !important;
		}

		/* What it does: Prevents Gmail from displaying an download button on large, non-linked images. */
		.a6S {
			display: none !important;
			opacity: 0.01 !important;
		}
		/* If the above doesn't work, add a .g-img class to any image in question. */
		img.g-img + div {
			display:none !important;
		}

		/* What it does: Prevents underlining the button text in Windows 10 */
		.button-link {
			text-decoration: none !important;
		}

		/* What it does: Removes right gutter in Gmail iOS app: https://github.com/TedGoas/Cerberus/issues/89  */
		/* Create one of these media queries for each additional viewport size you'd like to fix */
		/* Thanks to Eric Lepetit @ericlepetitsf) for help troubleshooting */
		@media only screen and (min-device-width: 375px) and (max-device-width: 413px) { /* iPhone 6 and 6+ */
			.email-container {
				min-width: 375px !important;
			}
		}

	</style>

	<!-- What it does: Makes background images in 72ppi Outlook render at correct size. -->
	<!--[if gte mso 9]>
	<xml>
		<o:OfficeDocumentSettings>
			<o:AllowPNG/>
			<o:PixelsPerInch>96</o:PixelsPerInch>
		</o:OfficeDocumentSettings>
	</xml>
	<![endif]-->

	<!-- Progressive Enhancements -->
	<style>

		/* What it does: Hover styles for buttons */
		.button-td,
		.button-a {
			transition: all 100ms ease-in;
		}
		.button-td:hover,
		.button-a:hover {
			background: #555555 !important;
			border-color: #555555 !important;
		}

	</style>

</head>
<body width="100%" bgcolor="#ebebeb" style="margin: 0; mso-line-height-rule: exactly;">
<center style="width: 100%; background: #ebebeb; text-align: left;padding-top: 30px;">

	<!--
		Set the email width. Defined in two places:
		1. max-width for all clients except Desktop Windows Outlook, allowing the email to squish on narrow but never go wider than 600px.
		2. MSO tags for Desktop Windows Outlook enforce a 600px width.
	-->
	<div style="max-width: 700px; margin: auto;" class="email-container">
		<!--[if mso]>
		<table role="presentation" aria-hidden="true" cellspacing="0" cellpadding="0" border="0" width="700" align="center" bgcolor="#ffffff">
			<tr>
				<td>
		<![endif]-->

		<!-- Email Header : BEGIN -->
		<table bgcolor="#262939" role="presentation" aria-hidden="true" cellspacing="0" cellpadding="0" border="0" align="center" width="100%" style="max-width: 700px; background-color: #262939;">
			<tr>
				<td style="width:620px; background: #fff; padding-top:12px;padding-bottom: 12px;padding-left: 40px;padding-right: 40px;">
					<img src="<?= FRONT_BASE_URL ?>/img/isun-logo-email.jpg" aria-hidden="true" width="144" height="45" alt="iSun" border="0" style="height: 40px; display: block">
				</td>
			</tr>
		</table>
		<!-- Email Header : END -->

		<!-- Email Body : BEGIN -->
		<table role="presentation" aria-hidden="true" cellspacing="0" cellpadding="0" border="0" align="center" width="100%" style="max-width: 700px;">
			<tr>
				<td bgcolor="#ffffff" style="width:680px;padding-top:10px;padding-bottom:10px;padding-left:10px;padding-right:10px;border-bottom: 1px solid #d5d9e1;">
					<table role="presentation" aria-hidden="true" cellspacing="0" cellpadding="0" border="0" width="100%">
						<tr>
							<td style="border:1px solid #cdd0dc; padding-right:30px;padding-left:30px;padding-bottom:30px;padding-top:30px;font-family: sans-serif; font-size: 14px; line-height: 22px; color: #5b6066;">

								<!-- CONTENT -->
								<table cellspacing="0" cellpadding="0" border="0" style="width: 620px; background: #ffffff">

									<tr>
										<td style="padding-bottom: 30px;">
											<p style="padding-top: 10px;">
												<strong <?= TemplateHelper::dataTemplateVar('custom', $custom) ?>><?= nl2br($custom) ?></strong>
											</p>
										</td>
									</tr>
								</table>
								<!-- \\ CONTENT -->

							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<!-- Email Body : END -->

		<!-- Email Footer : BEGIN -->
		<table width="700" cellspacing="0" cellpadding="0" border="0" style="width: 700px;">
			<tr>
				<td style="padding: 10px 40px; font-family: sans-serif; font-size: 12px;color: #797979;">RENEWZ © <?= date('Y') ?> All rights reserved.</td>
				<td style="padding: 10px 40px; text-align: right; font-family: sans-serif; font-size: 11px;color: #a084cb;text-decoration: none">
					<a href="<?= FRONT_BASE_URL ?>" target="_blank" style="color: #f0502d" ><?= preg_replace('~^[a-z]+://~', '', FRONT_BASE_URL) ?></a>
				</td>
			</tr>
		</table>
		<!-- Email Footer : END -->

		<!--[if mso]>
		</td>
		</tr>
		</table>
		<![endif]-->
	</div>
</center>
</body>
</html>