<?php
	$employees = ClassRegistry::init('Employee')->find('all', [
		'conditions' => [
			'Employee.page_id' => $page['Page']['id']
		]
	])
?>
<section class="bg-pattern">
	<div class="inner">
		<div class="employees-grid">
			<div class="row block-row __inline-row __2-block st__1-block">
				<?php foreach ($employees as $employee) { ?>
					<div class="column">
						<article>
							<div>
								<h2><?= $employee['Employee']['name'] ?></h2>
								<em><?= $employee['Employee']['position'] ?></em>
							</div>
							<div>
								<div class="rich-text" data-mh="group-1">
									<?= $employee['Employee']['text'] ?>
								</div>
								<a href="mailto:<?= $employee['Employee']['email'] ?>"><?= $employee['Employee']['email'] ?></a>
								<?php if(!empty($employee['Employee']['email_secondary'])) { ?>
									<a href="mailto:<?= $employee['Employee']['email_secondary'] ?>"><?= $employee['Employee']['email_secondary'] ?></a>
								<?php } ?>
							</div>
						</article>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>