<?php
	$grayUrl = "getUserVariable('GrayBlocUrl', 'string')";

	$listServices = ClassRegistry::init('ListService')->find('all', []);
?>

<section class="license-section">
	<div class="inner">
		<div class="row">
			<div class="column __5"><p><?php echo __('Posedujemo licence za baze podataka') ?></p></div>
			<div class="column __2"><img src="/img/buearu-van-dijk.png" /></div>
			<div class="column __5"><h3><?php echo __('Amadeus – Transfer Pricing Catalyst (Bureau Van dijk) i Scoring') ?></h3></div>
		</div>
	</div>
</section>

<section>
	<div class="inner">
		<div class="section-heading">
			<h2><?php echo __('Usluge revizije i konstaltinga') ?></h2>
		</div>

		<div class="section-body">
			<div class="service-grid">
				<div class="row block-row __inline-row __4-block st__3-block">
					<?php foreach ($listServices as $listService) { ?>
						<div class="column">
							<article>
								<div><img src="<?= $listService['Icon']['file'] ?>" /></div>
								<p><?= $listService['ListService']['title'] ?></p>
							</article>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>

		<div class="section-footer">
			<a href="<?= $this->Format->getPageFromSitemap(5, $sitemap, 'path')?>" class="button btn-primary"><span><?php echo __('Pročitajte više') ?></span></a>
		</div>
	</div>
</section>

<section class="bg-image" style="background-image: url(/img/fleksibilna-procena.jpg)">
	<div class="inner">
		<div class="section-heading">
			<h2 cms="block" type="string" name="GrayBlockTitle"></h2>
		</div>
		<div class="section-body">
			<div class="row">
				<div class="column __7 st__6">
					<div class="rich-text">
						<code cms="block" type="custom" name="GrayBlockText"></code>
					</div>
				</div>
			</div>
		</div>

		<div class="section-footer">
			<a href="<?= $grayUrl ?>" class="button btn-secondary btn-ghost"><span><?php echo __('Pročitajte više') ?></span></a>
		</div>
	</div>
</section>