<?php
App::uses('AppModel', 'Model');

class CmsContactForm extends AppModel {

	public $cache = false;

	public function hashCaptcha($value) {
		return md5(sha1($value, 'HzxlECrSsd4JvCEgmN3ocx5aBFb50XLjsHiyiCd6QrmxOpHm5CxungK0AdCh6rfO'));
	}

	public function isAddable() {
		return false;
	}

	function initValidation() {
		return [
			'name'    => [
				'notBlank' => [
					'rule'     => [ 'notBlank' ],
					'required' => true,
					'message'  => __('Please provide name') ] ],
			'email'   => [
				'notBlank' => [
					'rule'     => 'email',
					'required' => true,
					'message'  => __('Please provide valid email') ] ]
			// 		,
			// 'message' => [
			// 	'notBlank' => [
			// 		'rule'     => [ 'notBlank' ],
			// 		'required' => true,
			// 		'message'  => __('Please provide message') ] ]
			// 		,
			// 'captcha' => [
			// 	[
			// 		'rule'     => 'captchaValidation',
			// 		'required' => true,
			// 		'message'  => __('Please set correct result') ]
			// ]
		];
	}

	public function captchaValidation($value) {
		return $this->data[$this->alias]['hash'] === $this->hashCaptcha(reset($value));
	}
}
