<?php namespace Intellex\Curly\Content\Exception;

/**
 * Indicates that the content cannot be parsed with the desired content type.
 */
class ContentCannotBeParsedException extends \Exception {

	/**
	 * Initialize the exception.
	 *
	 * @param	string	$contentType	The content type that was used.
	 * @param	string	$content		The raw content.
	 */
	public function __construct($contentType, $content) {
		parent::__construct("Supplied content type `{$contentType}` cannot parse the supplied content: `{$content}`.");
	}

}
