<?php namespace Intellex\Curly\Content\Exception;

/**
 * Indicates that the requested content type does not exist or it is not yet supported.
 */
class ContentTypeNotSupportedException extends \Exception {

	/**
	 * Initialize the exception.
	 *
	 * @param	string	$contentType	The content type that was not recognized.
	 */
	public function __construct($contentType) {
		parent::__construct("Supplied content type `{$contentType}` is not supported.");
	}

}
