<?php namespace Intellex\Curly\Content;

/**
 * The base type for all content type handlers.
 */
interface TypeHandlerInterface {

	/**
	 * Parse the supplied raw content per content type rules.
	 *
	 * @param string $raw The raw content.
	 *
	 * @return mixed The parsed data.
	 * @throws Exception\ContentCannotBeParsedException On content which is not properly formatted
	 *                                                  for the this type.
	 */
	function parse($raw);

	/**
	 * Format the data based on the type.
	 *
	 * @param mixed $data The data to format.
	 *
	 * @return string The formatted data.
	 */
	function format($data);

}
