<?php namespace Intellex\Curly\Content\TypeHandlers;

use Intellex\Curly\Content\TypeHandlerInterface;

/**
 * Plain content, no parsing.
 */
class Plain implements TypeHandlerInterface {

	/**
	 * No modifications, just return the input..
	 *
	 * @param string $raw The raw content.
	 *
	 * @return string The original data.
	 */
	public function parse($raw) {
		return $raw;
	}

	/**
	 * Format the data based on the type.
	 *
	 * @param mixed $data The data to format.
	 *
	 * @return string The original data.
	 */
	function format($data) {

		// Handle empty data;
		if (empty($data)) {
			return '';
		}

		return $data;
	}

}
