<?php namespace Intellex\Curly\Enum;

/**
 * Class CurlOptions
 * Contains the list of options for the curl_setopt function.
 */
class CurlOptions {

	/**
	 * @var string[]  The list of all known curl options.
	 */
	private static $map = [
		3     => 'PORT',
		13    => 'TIMEOUT',
		14    => 'INFILESIZE',
		19    => 'LOW_SPEED_LIMIT',
		20    => 'LOW_SPEED_TIME',
		21    => 'RESUME_FROM',
		27    => 'CRLF',
		32    => 'SSLVERSION',
		33    => 'TIMECONDITION',
		34    => 'TIMEVALUE',
		41    => 'VERBOSE',
		42    => 'HEADER',
		43    => 'NOPROGRESS',
		44    => 'NOBODY',
		45    => 'FAILONERROR',
		46    => 'UPLOAD',
		47    => 'POST',
		48    => 'DIRLISTONLY',
		50    => 'APPEND',
		51    => 'NETRC',
		52    => 'FOLLOWLOCATION',
		53    => 'TRANSFERTEXT',
		54    => 'PUT',
		58    => 'AUTOREFERER',
		59    => 'PROXYPORT',
		61    => 'HTTPPROXYTUNNEL',
		64    => 'SSL_VERIFYPEER',
		68    => 'MAXREDIRS',
		69    => 'FILETIME',
		71    => 'MAXCONNECTS',
		72    => 'CLOSEPOLICY',
		74    => 'FRESH_CONNECT',
		75    => 'FORBID_REUSE',
		78    => 'CONNECTTIMEOUT',
		80    => 'HTTPGET',
		81    => 'SSL_VERIFYHOST',
		84    => 'HTTP_VERSION',
		85    => 'FTP_USE_EPSV',
		90    => 'SSLENGINE_DEFAULT',
		91    => 'DNS_USE_GLOBAL_CACHE',
		92    => 'DNS_CACHE_TIMEOUT',
		96    => 'COOKIESESSION',
		98    => 'BUFFERSIZE',
		99    => 'NOSIGNAL',
		101   => 'PROXYTYPE',
		105   => 'UNRESTRICTED_AUTH',
		106   => 'FTP_USE_EPRT',
		107   => 'HTTPAUTH',
		110   => 'FTP_CREATE_MISSING_DIRS',
		111   => 'PROXYAUTH',
		112   => 'FTP_RESPONSE_TIMEOUT',
		113   => 'IPRESOLVE',
		114   => 'MAXFILESIZE',
		119   => 'USE_SSL',
		121   => 'TCP_NODELAY',
		129   => 'FTPSSLAUTH',
		136   => 'IGNORE_CONTENT_LENGTH',
		137   => 'FTP_SKIP_PASV_IP',
		138   => 'FTP_FILEMETHOD',
		139   => 'LOCALPORT',
		140   => 'LOCALPORTRANGE',
		141   => 'CONNECT_ONLY',
		150   => 'SSL_SESSIONID_CACHE',
		151   => 'SSH_AUTH_TYPES',
		154   => 'FTP_SSL_CCC',
		155   => 'TIMEOUT_MS',
		156   => 'CONNECTTIMEOUT_MS',
		157   => 'HTTP_TRANSFER_DECODING',
		158   => 'HTTP_CONTENT_DECODING',
		159   => 'NEW_FILE_PERMS',
		160   => 'NEW_DIRECTORY_PERMS',
		161   => 'POSTREDIR',
		166   => 'PROXY_TRANSFER_MODE',
		171   => 'ADDRESS_SCOPE',
		178   => 'TFTP_BLKSIZE',
		180   => 'SOCKS5_GSSAPI_NEC',
		188   => 'FTP_USE_PRET',
		189   => 'RTSP_REQUEST',
		193   => 'RTSP_CLIENT_CSEQ',
		194   => 'RTSP_SERVER_CSEQ',
		197   => 'WILDCARDMATCH',
		207   => 'TRANSFER_ENCODING',
		210   => 'GSSAPI_DELEGATION',
		212   => 'ACCEPTTIMEOUT_MS',
		213   => 'TCP_KEEPALIVE',
		214   => 'TCP_KEEPIDLE',
		215   => 'TCP_KEEPINTVL',
		216   => 'SSL_OPTIONS',
		218   => 'SASL_IR',
		225   => 'SSL_ENABLE_NPN',
		226   => 'SSL_ENABLE_ALPN',
		227   => 'EXPECT_100_TIMEOUT_MS',
		229   => 'HEADEROPT',
		232   => 'SSL_VERIFYSTATUS',
		233   => 'SSL_FALSESTART',
		234   => 'PATH_AS_IS',
		237   => 'PIPEWAIT',
		239   => 'STREAM_WEIGHT',
		242   => 'TFTP_NO_OPTIONS',
		244   => 'TCP_FASTOPEN',
		10001 => 'FILE',
		10002 => 'URL',
		10004 => 'PROXY',
		10005 => 'USERPWD',
		10006 => 'PROXYUSERPWD',
		10007 => 'RANGE',
		10009 => 'READDATA',
		10015 => 'POSTFIELDS',
		10016 => 'REFERER',
		10017 => 'FTPPORT',
		10018 => 'USERAGENT',
		10022 => 'COOKIE',
		10023 => 'HTTPHEADER',
		10025 => 'SSLCERT',
		10026 => 'SSLCERTPASSWD',
		10028 => 'QUOTE',
		10029 => 'WRITEHEADER',
		10031 => 'COOKIEFILE',
		10036 => 'CUSTOMREQUEST',
		10037 => 'STDERR',
		10039 => 'POSTQUOTE',
		10062 => 'INTERFACE',
		10063 => 'KRBLEVEL',
		10065 => 'CAINFO',
		10070 => 'TELNETOPTIONS',
		10076 => 'RANDOM_FILE',
		10077 => 'EGDSOCKET',
		10082 => 'COOKIEJAR',
		10083 => 'SSL_CIPHER_LIST',
		10086 => 'SSLCERTTYPE',
		10087 => 'SSLKEY',
		10088 => 'SSLKEYTYPE',
		10089 => 'SSLENGINE',
		10093 => 'PREQUOTE',
		10097 => 'CAPATH',
		10100 => 'SHARE',
		10102 => 'ACCEPT_ENCODING',
		10103 => 'PRIVATE',
		10104 => 'HTTP200ALIASES',
		10118 => 'NETRC_FILE',
		10134 => 'FTP_ACCOUNT',
		10135 => 'COOKIELIST',
		10147 => 'FTP_ALTERNATIVE_TO_USER',
		10152 => 'SSH_PUBLIC_KEYFILE',
		10153 => 'SSH_PRIVATE_KEYFILE',
		10162 => 'SSH_HOST_PUBLIC_KEY_MD5',
		10169 => 'CRLFILE',
		10170 => 'ISSUERCERT',
		10173 => 'USERNAME',
		10174 => 'PASSWORD',
		10175 => 'PROXYUSERNAME',
		10176 => 'PROXYPASSWORD',
		10177 => 'NOPROXY',
		10179 => 'SOCKS5_GSSAPI_SERVICE',
		10183 => 'SSH_KNOWNHOSTS',
		10186 => 'MAIL_FROM',
		10187 => 'MAIL_RCPT',
		10190 => 'RTSP_SESSION_ID',
		10191 => 'RTSP_STREAM_URI',
		10192 => 'RTSP_TRANSPORT',
		10203 => 'RESOLVE',
		10204 => 'TLSAUTH_USERNAME',
		10205 => 'TLSAUTH_PASSWORD',
		10206 => 'TLSAUTH_TYPE',
		10211 => 'DNS_SERVERS',
		10217 => 'MAIL_AUTH',
		10220 => 'XOAUTH2_BEARER',
		10221 => 'DNS_INTERFACE',
		10222 => 'DNS_LOCAL_IP4',
		10223 => 'DNS_LOCAL_IP6',
		10224 => 'LOGIN_OPTIONS',
		10228 => 'PROXYHEADER',
		10230 => 'PINNEDPUBLICKEY',
		10231 => 'UNIX_SOCKET_PATH',
		10235 => 'PROXY_SERVICE_NAME',
		10236 => 'SERVICE_NAME',
		10238 => 'DEFAULT_PROTOCOL',
		10243 => 'CONNECT_TO',
		19913 => 'RETURNTRANSFER',
		19914 => 'BINARYTRANSFER',
		20011 => 'WRITEFUNCTION',
		20012 => 'READFUNCTION',
		20056 => 'PROGRESSFUNCTION',
		20079 => 'HEADERFUNCTION',
		20200 => 'FNMATCH_FUNCTION',
	];

	/**
	 * Get the name of the curl option, based on the numerical ID of the option.
	 *
	 * @return string The human readable name of the curl option.
	 */
	public static function getName($option) {
		return key_exists($option, static::$map) ? static::$map[$option] : 'UNKNOWN: ' . $options;
	}

}