<?php namespace Intellex\Curly\Exception;

/**
 * Indicates that the requested method does not exist or it is not yet supported.
 */
class MethodNotSupportedException extends \Exception {

	/**
	 * Initialize the exception.
	 *
	 * @param	string	$method	The method that was not recognized.
	 */
	public function __construct($method) {
		parent::__construct("Supplied HTTP method `{$method}` is not supported.");
	}

}
