<?php require '../vendor/autoload.php';

use Intellex\Curly\Content\TypeHandlers\JSON;
use Intellex\Curly\Content\Exception\ContentCannotBeParsedException;

$cases = [
	[ '{}', [  ] ],
	[ '[ ]', [  ] ],
	[ '[ 1, 2 ]', [ 1, 2 ] ],
	[ '[ "1", "2" ]', [ '1', '2' ] ],
	[ '{ "nested": { "Object1": true, "OBJECT 2": "string", "object3": 1 }, "indipendent": "node" }', [ 'nested' => [ 'Object1' => true, 'OBJECT 2' => 'string', 'object3' => 1 ], 'indipendent' => 'node' ] ],
	[ 'error', new ContentCannotBeParsedException('Json', 'error') ]
];

test($cases, function($input) { return (new JSON(null))->parse($input); });
