<?php require '../vendor/autoload.php';

use Intellex\Curly\URL;
use Intellex\Curly\Protocol;

$cases = [
	[ 'google.com',
		URL::create(Protocol::HTTP, 'google.com', '', []) ],

	[ 'google.com/',
		URL::create(Protocol::HTTP, 'google.com', '', []) ],

	[ 'http://google.com/',
		URL::create(Protocol::HTTP, 'google.com', '', []) ],

	[ 'https://google.com/hello',
		URL::create(Protocol::HTTPS, 'google.com', 'hello', []) ],

	[ 'https://google.com/hello/there',
		URL::create(Protocol::HTTPS, 'google.com', 'hello/there', []) ],

	[ 'https://google.com/hello/there?get=true',
		URL::create(Protocol::HTTPS, 'google.com', '/hello/there', [ 'get' => 'true' ]) ],

	[ 'https://google.com/hello/there?get=true',
		URL::create(Protocol::HTTPS, 'google.com', 'hello/there?get=true') ],

	[ 'HTTPS://google.com/hello/there?user[name]=Ivan&user[surname]=Sabo',
		URL::create(Protocol::HTTPS, 'google.com', 'hello/there', [ 'user' => [ 'name' => 'Ivan', 'surname' => 'Sabo' ] ]) ],

	[ 'https://www.intellex.rs/about-us',
		URL::create(Protocol::HTTPS, 'www.intellex.rs', 'about-us', []) ],

	[ 'Http://intellex.rs/404-error-page',
		URL::create(Protocol::HTTP, 'intellex.rs', '404-error-page', []) ],
];

test(
	$cases,
	function ($input, $expected) {
		return new \Intellex\Curly\URL($input);
	},
	function ($input, $expected, $result) {
		return
			$expected->getProtocol() == $result->getProtocol() &&
			$expected->getHost() === $result->getHost() &&
			$expected->getPath() === $result->getPath() &&
			$expected->getQuery() === $result->getQuery();
	}
);

