<?php require '../vendor/autoload.php';

use Intellex\Curly\URL;

$cases = [
	[ '?',
		[ ] ],

	[ '?asd',
		[ 'asd' => '' ] ],

	[ 'hello ',
		[ 'hello' => '' ] ],

	[ ' hello=world',
		[ 'hello' => 'world' ] ],

	[ 'šišmiš=true&ćurka=yes&',
		[ 'šišmiš' => 'true', 'ćurka' => 'yes' ] ],

	[ 'a=1&a=2',
		[ 'a' => '2' ]] ,

	[ 'a[]=1&a[]=2',
		[ 'a' => [ '1', '2' ] ] ],

	[ 'user[first_name]=Ivan&user[last_name]=Sabo&user[company]=Intellex\ doo&location[country]=Serbia&location[city][name]=Belgrade&location[city][part]=ЗЕМУН&save=1&',
		[ 'user' => [ 'first_name' => 'Ivan', 'last_name' => 'Sabo', 'company' => 'Intellex\ doo' ], 'location' => [ 'country' => 'Serbia', 'city' => [ 'name' => 'Belgrade', 'part' => 'ЗЕМУН' ] ], 'save' => '1' ] ],
];

test($cases, function($input) { return \Intellex\Curly\URL::parseGetQuery($input); });
