<?php require '../vendor/autoload.php';

define('START_TIME', microtime(true));

\Intellex\Debugger\Debugger::initHandlers();
function debug($data) { \Intellex\Debugger\Debugger::dump($data, 1); }

# Define test method
function test($cases, $callback, $assert = null) {

	# Get the trace
	$trace = debug_backtrace();
	list($class, $method) = explode('-', basename(substr($trace[0]['file'], 0, -4)));

	# Execute tests
	foreach($cases as $i => $data) {
		list($input, $expected) = $data;
		try {

			# Custom assert
			if(empty($assert)) {
				$assert = function($input, $expected, $result) {
					return is_object($result) ? $result == $expected : $result == $expected;
				};
			}

			# If failed
			$result = $callback($input, $expected);
			if(!$assert($input, $expected, $result)) {
				echo "Failed test of {$class}::{$method}().";
				echo '<br />';
				echo 'Input:'; var_dump($input);
				echo '<br />';
				echo 'Expected:'; var_dump($expected);
				echo '<br />';
				echo 'Recevied:'; var_dump($result);
				die(1);
			}

		} catch(Exception $e) {
			if(!is_object($expected) || get_class($e) !== get_class($expected)) {
				echo "Failed test of {$class}::{$method}().";
				echo '<br />';
				echo 'Unexpected exception: ' . get_class($e);
				throw $e;
				die(1);
			}
		}
	}
}

# Load and run all tests
$index = basename(__FILE__);
$files = glob('./*.php');
foreach($files as $file) {
	$basename = basename($file);
	if($basename{0} !== '.' && $basename !== $index && strstr($basename, '-') !== false) {
		require $file;
	}
}

echo 'All tests passed in ' . (microtime(true) - START_TIME) * 1000 . ' milliseconds' . PHP_EOL;
exit(0);
