<?php require_once __DIR__ . '/../../Debugger.php';

/**
 * @var \Exception $exception The exception to render.
 * @var array      $history   The complete trace history.
 */

$open = 1;
foreach ($history as $i => $step) {
	if (key_exists('file', $step) && key_exists('line', $step) && (empty($origin) || ($origin['file'] == $step['file'] && $origin['line'] == $step['line']))) {
		$open = $i;
		break;
	}
}
?>
<!DOCTYPE html>
<head>
	<meta charset="utf-8">
	<title>Exception: <?= $exception->getMessage() ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<style>
		body { padding: 0; margin: 0; font: normal 14px Arial; background: #fff; width: 100%; height: 100%; color: #555; }
		/* Header */
		header { padding: 20px 40px 0 20px; background: #C05C5C; top: 0; left: 0; right: 0; box-sizing: border-box; position: relative; }
		h1 { color: white; }
		svg.icon { width: 95px; height: 95px; fill: white; float: right; opacity: }
		nav { position; absolute; left: 0; bottom: 0; }
		nav a { display: inline-block; padding: 12px 20px; border: solid 1px rgba(0, 0, 0, 0); text-decoration: none !important; color: white; }
		nav a:hover { background: white; color: #555; }
		nav a.active { color: #555; background: white; border: solid 1px #bbb; border-bottom: solid 1px white; }
		section { display: none; }
		section.show { display: block; }
		/* Stack trace */
		ul.trace { list-style: none; padding: 0; margin: 0; }
		ul.trace > li { border-bottom: 1px solid #bbb; }
		ul.trace > li .code .line:hover { background: #eee; }
		ul.trace > li .code .line.highlighted { background: #FFFF92; }
		ul.trace > li .file { font-size: 21px; text-decoration: none !important; width: 100%; padding: 8px 14px; color: inherit; display: block; }
		ul.trace > li .file:hover { background: #f5f5f5; }
		ul.trace > li .file:nth-child(0) { display: none; }
		/* Title */
		.path { color: #AAB7C3; }
		.class { }
		.type { font-size: 90%; }
		.function { color: #A54EA5; }
		.arg { color: #2FAA2F; }
		/* Code highlight */
		code, div.code, div.array { font: normal 16px Monospace, Courier; background: none; color: #555; }
		div.code { display: none; padding: 5px 8px 12px; }
		div.code.opened { display: block; padding: 12px 70px 25px; }
		div.array { display: none; margin: 0 14px;; }
		div.array.opened { display: block; }
		span.php-line { color: #BBB; }
		span.php-comment { color: #BBB; }
		span.php-default { }
		span.php-html { }
		span.php-keyword { color: #1967E1; }
		span.php-string { color: #129712; }
		/* Footer */
		footer { padding: 4px 14px; text-align: right; }
	</style>
</head>
<body>
<header>
	<svg class="icon" width="40" height="40" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg">
		<path d="M1024 1375v-190q0-14-9.5-23.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 23.5v190q0 14 9.5 23.5t22.5 9.5h192q13 0 22.5-9.5t9.5-23.5zm-2-374l18-459q0-12-10-19-13-11-24-11h-220q-11 0-24 11-10 7-10 21l17 457q0 10 10 16.5t24 6.5h185q14 0 23.5-6.5t10.5-16.5zm-14-934l768 1408q35 63-2 126-17 29-46.5 46t-63.5 17h-1536q-34 0-63.5-17t-46.5-46q-37-63-2-126l768-1408q17-31 47-49t65-18 65 18 47 49z" />
	</svg>
	<h1><?= $exception->getMessage() ?></h1>

	<nav>
		<a href="#Stacktrace" onclick="nav(this); return false;" class="active">Stack trace</a>
		<a href="#Environment" onclick="nav(this); return false;">Environment</a>
	</nav>
</header>

<section id="Stacktrace" class="show">
	<ul class="trace">
		<?php foreach ($history as $i => $step) { ?>
			<li class="step">
				<a class="file" data-step="<?= $i ?>" onclick="<?= key_exists('file', $step) ? 'toggle(this); ' : null ?>return false;" href="#step-<?= $i ?>">

					<?php if (key_exists('class', $step)) { ?>
						<span class="class"><?= $step['class'] ?></span>
					<?php } ?>

					<?php if (key_exists('type', $step)) { ?>
						<span class="type"><?= $step['type'] ?></span>
					<?php } ?>

					<?php if (key_exists('function', $step)) { ?>
						<span class="function"><?= $step['function'] ?></span>
						(<?php if (key_exists('args', $step))
							foreach ($step['args'] as $a => $arg)
								echo ($a ? ', ' : null) . '<span class="arg">' . \Intellex\Debugger\Debugger::getReadableValue($arg, 32) . '</span>' ?>)
					<?php } ?>

					<br />

					<span class="path"><?= key_exists('file', $step) ? $step['file'] . ' : ' . $step['line'] : null ?></span>
				</a>

				<div class="code<?= $open === $i ? ' opened' : null ?>" data-step="<?= $i ?>">
					<?php
					echo \Intellex\Debugger\Debugger::formatCode(file_get_contents($step['file']), $step['line'], $step['line'] - 8, $step['line'] + 8);
					?>
				</div>
			</li>
		<?php } ?>
	</ul>
</section>

<section id="Environment">
	<ul class="trace">
		<?php foreach ([ 'REQUEST' => $_REQUEST, 'SERVER' => $_SERVER, 'COOKIE' => $_COOKIE, 'FILES' => $_FILES ] as $var => $data) { ?>
			<li class="step">
				<a class="file" data-var="<?= $i ?>" onclick="toggle(this); return false;" href="#var-<?= $i ?>">
					<span class="path">$_<?= $var ?></span>
				</a>

				<div class="array<?= !isset($firstEnv) ? ' opened' : null ?>" data-var="<?= $i ?>">
					<pre><?php echo \Intellex\Debugger\Debugger::getReadableValue($data) ?></pre>
				</div>
			</li>
			<?php $firstEnv = true;
		} ?>
	</ul>
</section>

<footer><p>&copy; intellexapps/debugger <?= date('Y') ?></p></footer>

<script type="text/javascript">
	function toggle(item) {
		item.nextSibling.nextSibling.classList.toggle('opened');
	}

	function nav(item) {
		closeSiblings(item, 'active');

		var section = document.getElementById(item.href.replace(/^.+#/, ''));
		closeSiblings(section, 'show');
		return false;
	}

	function closeSiblings(item, className) {
		for (var i in item.parentNode.childNodes) {
			if (item.parentNode.childNodes.hasOwnProperty(i)) {
				if (item.parentNode.childNodes[i].nodeName && item.parentNode.childNodes[i].nodeName != '#text') {
					item.parentNode.childNodes[i].classList.remove(className);
				}
			}
		}
		item.classList.add(className);
	}
</script>
</body>
</html>
