<?php

/**
 * @var \Exception $exception The exception to render.
 * @var array      $history   The complete trace history.
 */

$json = [
	'error' => [
		'message'     => $exception->getMessage(),
		'trace'       => [],
		'environment' => [
			'REQUEST' => $_REQUEST,
			'SERVER'  => $_SERVER,
			'COOKIE'  => $_COOKIE,
			'FILES'   => $_FILES,
		]
	]
];

// Stack trace
foreach ($history as $i => $step) {
	$json['error']['trace'][] = $step;
}

// Print JSON
header('Content-Type: application/json');
echo json_encode($json, JSON_PRETTY_PRINT);
