<?php

	# Style
	$wide = 120;
	$chars = [
		[ "╒", "═", "╕" ],
		[ "├", "─", "┤" ],
		[ "│", " ", "│" ],
		[ "╘", "═", "╛" ]
	];

	# Set the template
	$template  = $chars[0][0] . str_repeat($chars[0][1], $wide-2) . $chars[0][2] . "\n";
	$template .= $chars[2][0] .  ' ' . "%s" . $chars[2][2] . "\n";
	$template .= $chars[1][0] . str_repeat($chars[1][1], $wide-2) . $chars[1][2] . "\n";
	$template .= $chars[2][0] . str_repeat(' ', $wide-2) . $chars[2][2] . "\n";
	$template .= "%s\n";
	$template .= $chars[2][0] . str_repeat(' ', $wide-2) . $chars[2][2] . "\n";
	$template .= $chars[3][0] . str_repeat($chars[3][1], $wide-2) . $chars[3][2] . "\n";

	# Create
	$source = $data['file'] . ' : ' . $data['line'];
	$source .= str_repeat(' ', max(1, $wide - 3 - strlen($source)));
	$lines = explode("\n", $data['value']);

	# Lines
	foreach($lines as $i => $val) {
		$lines[$i]  = $chars[2][0] . ' ' . $lines[$i];
		$lines[$i] .= str_repeat(' ', max(1, $wide + 1 - strlen($lines[$i])));
		$lines[$i] .= $chars[2][2];
	}

	# Print
	printf($template, $source, implode("\n", $lines));


