<?php require '../vendor/autoload.php';
use \Intellex\Debugger\Debugger;

$cases = [

	# Null
	[ null, '(null value)' ],

	# Boolean
	[ true,			'boolean: true' ],
	[ false,		'boolean: false' ],
	[ !1,			'boolean: false' ],
	[ empty([]),	'boolean: true' ],

	# Integer
	[ -1,			'integer: -1' ],
	[ -0,			'integer: 0' ],
	[ 0,			'integer: 0' ],
	[ 1,			'integer: 1' ],
	[ 11,			'integer: 11' ],
	[ 10+7,			'integer: 17' ],
	[ 25/5,			'integer: 5' ],
	[ 25*5,			'integer: 125' ],

	# Integer
	[ -1,			'integer: -1' ],
	[ -0,			'integer: 0' ],
	[ 0,			'integer: 0' ],
	[ 1,			'integer: 1' ],
	[ 11,			'integer: 11' ],
	[ 10+7,			'integer: 17' ],
	[ 25/5,			'integer: 5' ],
	[ 25*5,			'integer: 125' ],

	# Float
	[ -1.0,			'float: -1' ],
	[ -0.0,			'float: -0' ],
	[ 0.0,			'float: 0' ],
	[ 1.0,			'float: 1' ],
	[ 11.0,			'float: 11' ],
	[ 10.0+7.0,		'float: 17' ],
	[ 25.0/5,		'float: 5' ],
	[ 25*5.0,		'float: 125' ],
	[ 12/5,			'float: 2.4' ],
	[ ceil(10/3),	'float: 4' ],

	# String
	[ '',			'string(0): ""' ],
	[ ' ',			'string(1): " "' ],
	[ "\t\n" ,		'string(2): "' . "\t\n" . '"' ],
	[ "line\n" ,	'string(5): "line' . "\n" . '"' ],
	[ "new\nline" ,	'new' . "\n" . 'line' ],
	[ '\n',			'\n' ],
	[ 1 . 1 ,		'11' ],

	# Array
	[ [ ],					print_r([], true) ],

	# Object
	[ new stdClass,			print_r(new stdClass, true) ],

	# Resource
	// TODO

];

# Test
test($cases, function($input) { return Debugger::getReadableValue($input); });
