<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 19.10.17.
 * Time: 14.28
 */

namespace Intellex\Generator\Basic;

use Intellex\Generator\Core\GaussianDistributionGenerator;

class TimeGenerator extends GaussianDistributionGenerator {

	/** @var boolean Set to true to use normal distribution around middle time. */
	private $gauss;

	/** @var bool $seconds Adds seconds to time format */
	private $seconds;

	/**
	 * TimeGenerator constructor.
	 *
	 * @param int|string $from    Starting range for random date.
	 * @param int|string $to      Ending range for random date.
	 * @param bool       $seconds Adds seconds to time format
	 * @param bool       $gauss   Set to true to use normal distribution around middle time.
	 */
	public function __construct($from = '-12 hour', $to = '+12 hour', $seconds = true, $gauss = false) {
		$from = strtotime($from);
		$to = strtotime($to);
		$diff = ($to - $from) / 2;
		$mean = $from + $diff;
		$deviation = $diff / 5;
		$this->seconds = $seconds;
		parent::__construct($mean, $deviation, $from, $to);
	}

	/**
	 * Generate a value for a column.
	 *
	 * @return mixed The generated value.
	 */
	public function generateValue() {
		if ($this->gauss) {
			$date = parent::generateValue();
		} else {
			$date = rand($this->min, $this->max);
		}

		if ($this->seconds === false) {
			return date('​H:i', $date);
		} else {
			return date('H:i:s', $date);
		}

	}
}