<?php

namespace Intellex\Generator\Core;

class WeightedItemGenerator implements GeneratorInterface {

	/** @var array List of all possible values. */
	private $values = [ ];

	/**
	 * BooleanGenerator constructor.
	 *
	 * @param mixed $array Associative array of value => weight
	 */
	public function __construct($array) {
		foreach ($array as $value => $weight) {
			$this->values = array_merge($this->values, array_fill(0, $weight, $value));
		}

		// There must be at least one item in array
		if (empty($this->values)) {
			throw new \InvalidArgumentException("Empty array supplied.");
		}
	}

	/**
	 * Generate a value for a column.
	 *
	 * @return mixed The generated value.
	 */
	public function generateValue() {
		return $this->values[rand(0, sizeof($this->values) - 1)];
	}

}