<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 26.10.17.
 * Time: 10.50
 */

namespace Intellex\Generator\Text;

class ArticleGenerator extends ParagraphGenerator {

	/** @var int $min Minimum number of paragraphs generated in article */
	private $min;

	/** @var int $max Maximum number of paragraphs generated in article */
	private $max;

	/**
	 * ArticleGenerator constructor.
	 *
	 * @param int $min Minimum number of paragraphs generated in article
	 * @param int $max Maximum number of paragraphs generated in article
	 */
	public function __construct($min = 5, $max = 10) {
		parent::__construct();
		$this->min = $min;
		$this->max = $max;
	}

	/**
	 * Generates single article.
	 *
	 * @return string
	 */
	public function generateValue() {
		return $this->generateArticle();
	}

	/**
	 * Generates single article.
	 *
	 * @return string
	 */
	public function generateArticle() {
		$article = [ ];
		$length = rand($this->min, $this->max);
		$title = new SentenceGenerator(5, 25, false);
		$article[] .= $title->generateValue();
		while ($length--) {
			$article[] .= parent::generateValue();
		}
		return implode("\n\n", $article);
	}

}